/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.stickyenchantinglapis_common_forge.networking.packets;

import com.natamus.collective_common_forge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_forge.implementations.networking.data.Side;
import com.natamus.stickyenchantinglapis_common_forge.util.ClientUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ToClientReceiveLapisCountPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"stickyenchantinglapis", (String)"to_client_receive_lapis_count_packet");
    private final int lapisCount;
    private final int enchantingTableXPosition;
    private final int enchantingTableYPosition;
    private final int enchantingTableZPosition;

    public ToClientReceiveLapisCountPacket(int lapisCountIn, int enchantingTableXPositionIn, int enchantingTableYPositionIn, int enchantingTableZPositionIn) {
        this.lapisCount = lapisCountIn;
        this.enchantingTableXPosition = enchantingTableXPositionIn;
        this.enchantingTableYPosition = enchantingTableYPositionIn;
        this.enchantingTableZPosition = enchantingTableZPositionIn;
    }

    public static ToClientReceiveLapisCountPacket decode(FriendlyByteBuf buf) {
        int lapisCountIn = buf.readInt();
        int enchantingTableXPosition = buf.readInt();
        int enchantingTableYPosition = buf.readInt();
        int enchantingTableZPosition = buf.readInt();
        return new ToClientReceiveLapisCountPacket(lapisCountIn, enchantingTableXPosition, enchantingTableYPosition, enchantingTableZPosition);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.lapisCount);
        buf.writeInt(this.enchantingTableXPosition);
        buf.writeInt(this.enchantingTableYPosition);
        buf.writeInt(this.enchantingTableZPosition);
    }

    public static void handle(PacketContext<ToClientReceiveLapisCountPacket> ctx) {
        if (ctx.side().equals((Object)Side.CLIENT)) {
            ToClientReceiveLapisCountPacket packet = (ToClientReceiveLapisCountPacket)ctx.message();
            ClientUtil.syncLapisToClients(packet.lapisCount, new BlockPos(packet.enchantingTableXPosition, packet.enchantingTableYPosition, packet.enchantingTableZPosition));
        }
    }
}

