/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.stickyenchantinglapis_common_fabric.mixin;

import com.natamus.collective_common_fabric.implementations.networking.api.Dispatcher;
import com.natamus.stickyenchantinglapis_common_fabric.data.Variables;
import com.natamus.stickyenchantinglapis_common_fabric.networking.packets.ToClientReceiveLapisCountPacket;
import com.natamus.stickyenchantinglapis_common_fabric.util.Util;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1718;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2605;
import net.minecraft.class_3218;
import net.minecraft.class_3914;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1718.class}, priority=1001)
public class EnchantmentMenuMixin {
    @Shadow
    @Final
    private class_1263 field_7809;
    @Unique
    private class_1657 player;

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="TAIL")})
    public void EnchantmentMenu(int i, class_1661 inventory, class_3914 containerLevelAccess, CallbackInfo ci) {
        int lapisCount;
        this.player = inventory.field_7546;
        class_2605 enchantingTableBlockEntity = Util.getEnchantingTableBlockEntity(this.player);
        if (enchantingTableBlockEntity != null && (lapisCount = Util.getLapisCount(this.player.method_37908(), enchantingTableBlockEntity)) > 0) {
            this.field_7809.method_5447(1, new class_1799((class_1935)class_1802.field_8759, lapisCount));
        }
    }

    @Inject(method={"slotsChanged(Lnet/minecraft/world/Container;)V"}, at={@At(value="TAIL")})
    public void slotsChanged(class_1263 container, CallbackInfo ci) {
        class_2605 enchantingTableBlockEntity;
        if (this.player == null) {
            return;
        }
        int lapisCount = 0;
        class_1799 itemStack = this.field_7809.method_5438(1);
        if (itemStack.method_7909().equals(class_1802.field_8759)) {
            lapisCount = itemStack.method_7947();
        }
        if ((enchantingTableBlockEntity = Util.getEnchantingTableBlockEntity(this.player)) != null) {
            class_1937 level = this.player.method_37908();
            if (lapisCount == Util.getLapisCount(level, enchantingTableBlockEntity)) {
                return;
            }
            Util.saveLapisCount(level, enchantingTableBlockEntity, lapisCount);
            if (!level.field_9236) {
                class_2338 enchantingTableBlockPos = enchantingTableBlockEntity.method_11016();
                Dispatcher.sendToClientsInLevel((Object)new ToClientReceiveLapisCountPacket(lapisCount, enchantingTableBlockPos.method_10263(), enchantingTableBlockPos.method_10264(), enchantingTableBlockPos.method_10260()), (class_3218)((class_3218)level));
                for (class_1657 otherPlayer : level.method_8503().method_3760().method_14571()) {
                    UUID otherPlayerUUID = otherPlayer.method_5667();
                    if (otherPlayerUUID.equals(this.player.method_5667())) continue;
                    if (!Variables.lastEnchantingTableInteraction.containsKey(otherPlayerUUID)) {
                        return;
                    }
                    if (!enchantingTableBlockEntity.method_11016().equals((Object)Variables.lastEnchantingTableInteraction.get(otherPlayerUUID))) {
                        return;
                    }
                    if (!(otherPlayer.field_7512 instanceof class_1718)) continue;
                    otherPlayer.field_7512.method_7611(1).method_7673(new class_1799((class_1935)class_1802.field_8759, lapisCount));
                }
            }
        }
    }

    @Inject(method={"removed(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")})
    public void removed(class_1657 player, CallbackInfo ci) {
        this.player = null;
    }
}

