/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.gui.buttons;

import appeng.client.gui.Icon;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.IconButton;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class BaseButton
extends IconButton {
    public BaseButton(Button.OnPress onPress) {
        super(onPress);
    }

    abstract Blitter getBlitterIcon();

    protected final Icon getIcon() {
        return null;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            Blitter blitter = this.getBlitterIcon();
            if (!this.active) {
                blitter.opacity(0.5f);
            }
            if (this.isHalfSize()) {
                this.width = 8;
                this.height = 8;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (this.isFocused()) {
                guiGraphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY(), -1);
                guiGraphics.fill(this.getX() - 1, this.getY(), this.getX(), this.getY() + this.height, -1);
                guiGraphics.fill(this.getX() + this.width, this.getY(), this.getX() + this.width + 1, this.getY() + this.height, -1);
                guiGraphics.fill(this.getX() - 1, this.getY() + this.height, this.getX() + this.width + 1, this.getY() + this.height + 1, -1);
            }
            if (this.isHalfSize()) {
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                pose.translate((float)this.getX(), (float)this.getY(), 0.0f);
                pose.scale(0.5f, 0.5f, 1.0f);
                if (!this.isDisableBackground()) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(0, 0).blit(guiGraphics);
                }
                blitter.dest(0, 0).blit(guiGraphics);
                pose.popPose();
            } else {
                if (!this.isDisableBackground()) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(this.getX(), this.getY()).blit(guiGraphics);
                }
                blitter.dest(this.getX(), this.getY()).blit(guiGraphics);
            }
            RenderSystem.enableDepthTest();
            Item item = this.getItemOverlay();
            if (item != null) {
                guiGraphics.renderItem(new ItemStack((ItemLike)item), this.getX(), this.getY());
            }
        }
    }
}

