/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.mapicon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityIcons;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class EntityImageIcon
extends Icon {
    @Nullable
    private final Slice mainSlice;
    private final List<ChildIconData> children;
    private final Icon mainIcon;
    private final List<Icon> childIcons;
    @Nullable
    private final EntityIcons.WidthHeight defaultImageSize;

    public EntityImageIcon(ResourceLocation mainTexture, @Nullable Slice mainSlice, List<ChildIconData> children, @Nullable EntityIcons.WidthHeight defaultImageSize) {
        this.mainSlice = mainSlice;
        this.children = children;
        this.defaultImageSize = defaultImageSize;
        this.mainIcon = this.createIcon(mainTexture, mainSlice);
        this.childIcons = children.stream().map(childIconData -> this.createIcon(childIconData.texture.orElse(mainTexture), childIconData.slice)).toList();
    }

    public void draw(GuiGraphics graphics, int x, int y, int width, int height) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        float drawWidth = this.mainSlice == null ? (float)width : (float)this.mainSlice.width;
        float drawHeight = this.mainSlice == null ? (float)height : (float)this.mainSlice.height;
        float scaleX = (float)width / drawWidth;
        float scaleY = (float)height / drawHeight;
        pose.scale(scaleX, scaleY, 1.0f);
        this.mainIcon.draw(graphics, 0, 0, (int)drawWidth, (int)drawHeight);
        for (int i = 0; i < this.children.size(); ++i) {
            ChildIconData child = this.children.get(i);
            Icon icon = this.childIcons.get(i);
            pose.pushPose();
            child.offset.ifPresent(offset -> pose.translate((float)offset.x, (float)offset.y, 0.0f));
            icon.draw(graphics, 0, 0, child.slice.width, child.slice.height);
            pose.popPose();
        }
        pose.popPose();
    }

    private Icon createIcon(ResourceLocation texture, @Nullable Slice slice) {
        SimpleTexture.TextureImage load = SimpleTexture.TextureImage.load((ResourceManager)Minecraft.getInstance().getResourceManager(), (ResourceLocation)texture);
        try {
            ImageIcon imageIcon = new ImageIcon(texture);
            if (slice != null) {
                int textureWidth = load.getImage().getWidth();
                int textureHeight = load.getImage().getHeight();
                if (this.defaultImageSize != null) {
                    int defaultTextureWidth = this.defaultImageSize.width();
                    int defaultTextureHeight = this.defaultImageSize.height();
                    float scaleX = (float)textureWidth / (float)defaultTextureWidth;
                    float scaleY = (float)textureHeight / (float)defaultTextureHeight;
                    return imageIcon.withUV((float)slice.x * scaleX, (float)slice.y * scaleY, (float)slice.width * scaleX, (float)slice.height * scaleY, (float)textureWidth, (float)textureHeight);
                }
                return imageIcon.withUV((float)slice.x, (float)slice.y, (float)slice.width, (float)slice.height, (float)textureWidth, (float)textureHeight);
            }
            return imageIcon;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load image: " + String.valueOf(texture), e);
        }
    }

    public record Slice(int x, int y, int width, int height) {
        public static final Codec<Slice> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y), (App)Codec.INT.fieldOf("width").forGetter(s -> s.width), (App)Codec.INT.fieldOf("height").forGetter(s -> s.height)).apply((Applicative)builder, Slice::new));
    }

    public record ChildIconData(Optional<ResourceLocation> texture, Slice slice, Optional<Offset> offset) {
        public static final Codec<ChildIconData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("texture").forGetter(entityImageIcon -> entityImageIcon.texture), (App)Slice.CODEC.fieldOf("slice").forGetter(ChildIconData::slice), (App)Offset.CODEC.optionalFieldOf("offset").forGetter(ChildIconData::offset)).apply((Applicative)instance, ChildIconData::new));
    }

    public record Offset(int x, int y) {
        public static final Codec<Offset> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y)).apply((Applicative)builder, Offset::new));
    }
}

