/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.api.client.minimap;

import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapContext;
import dev.ftb.mods.ftbchunks.api.client.minimap.TranslatedOption;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public interface MinimapInfoComponent {
    public ResourceLocation id();

    public void render(MinimapContext var1, GuiGraphics var2, Font var3);

    default public Set<TranslatedOption> getConfigComponents() {
        return Set.of();
    }

    default public int height(MinimapContext context) {
        return this.computeLineHeight(context.minecraft(), 1) + 1;
    }

    default public boolean shouldRender(MinimapContext context) {
        return true;
    }

    default public int computeLineHeight(Minecraft minecraft, int lines) {
        float fontScale = ((Double)FTBChunksClientConfig.MINIMAP_FONT_SCALE.get()).floatValue();
        Objects.requireNonNull(minecraft.font);
        return (int)((float)((9 + 2) * lines) * fontScale);
    }

    default public void drawCenteredText(Font font, GuiGraphics graphics, Component text, int y) {
        int textWidth = font.width(text.getVisualOrderText());
        graphics.drawString(font, text, -textWidth / 2, y, -1, true);
    }

    default public Component displayName() {
        return Component.translatable((String)("minimap.info." + this.id().getNamespace() + "." + this.id().getPath() + ".title"));
    }

    default public Component description() {
        return Component.translatable((String)("minimap.info." + this.id().getNamespace() + "." + this.id().getPath() + ".description"));
    }
}

