/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.forge;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.gui.impl.forge.ForgeHelpers;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.utils.Helpers;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.ModConfigSpec;
import speiger.src.collections.objects.utils.ObjectLists;

public class SaveForgeConfigPacket
implements ICarbonPacket {
    public static final StreamCodec<FriendlyByteBuf, SaveForgeConfigPacket> STREAM_CODEC = CustomPacketPayload.codec(SaveForgeConfigPacket::write, ICarbonPacket.readPacket(SaveForgeConfigPacket::new));
    public static final CustomPacketPayload.Type<SaveForgeConfigPacket> ID = ICarbonPacket.createType("carbonconfig:save_neo");
    ModConfig.Type type;
    String modId;
    String fileName;
    byte[] data;

    public SaveForgeConfigPacket(ModConfig.Type type, String modId, String fileName, byte[] data) {
        this.type = type;
        this.modId = modId;
        this.fileName = fileName;
        this.data = data;
    }

    public SaveForgeConfigPacket(FriendlyByteBuf buffer) {
        this.type = (ModConfig.Type)buffer.readEnum(ModConfig.Type.class);
        this.modId = buffer.readUtf(Short.MAX_VALUE);
        this.fileName = buffer.readUtf(Short.MAX_VALUE);
        this.data = buffer.readByteArray();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.type);
        buffer.writeUtf(this.modId, Short.MAX_VALUE);
        buffer.writeUtf(this.fileName, Short.MAX_VALUE);
        buffer.writeByteArray(this.data);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            return;
        }
        ModConfig config = this.findConfig();
        if (config == null) {
            return;
        }
        IConfigSpec.ILoadedConfig loaded = (IConfigSpec.ILoadedConfig)ObfuscationReflectionHelper.getPrivateValue(ModConfig.class, (Object)config, (String)"loadedConfig");
        ForgeHelpers.saveConfig((CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(this.data)), loaded);
        ((ModConfigSpec)config.getSpec()).afterReload();
        CarbonConfig.LOGGER.info("Saved [" + this.modId + "] " + Helpers.firstLetterUppercase(this.type.extension()) + " Config");
    }

    private ModConfig findConfig() {
        for (ModConfig config : ForgeHelpers.getConfigs().getOrDefault(this.modId, (List<ModConfig>)ObjectLists.empty())) {
            if (config.getType() != this.type || !this.fileName.equals(config.getFileName())) continue;
            return config;
        }
        return null;
    }
}

