/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.api.IRequestScreen;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.ConfigScreen;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RequestScreen
extends ListScreen
implements IRequestScreen {
    static final Component REQUEST = Component.translatable((String)"gui.carbonconfig.requesting_config");
    static final Component[] ANIMATION = new Component[]{Component.literal((String)"Ooooo").withStyle(ChatFormatting.GRAY), Component.literal((String)"oOooo").withStyle(ChatFormatting.GRAY), Component.literal((String)"ooOoo").withStyle(ChatFormatting.GRAY), Component.literal((String)"oooOo").withStyle(ChatFormatting.GRAY), Component.literal((String)"ooooO").withStyle(ChatFormatting.GRAY)};
    Screen parent;
    IModConfig config;
    UUID requestId;
    Predicate<FriendlyByteBuf> result;
    ConfigScreen.Navigator nav;
    int tick = 0;

    public RequestScreen(BackgroundTexture.BackgroundHolder customTexture, ConfigScreen.Navigator nav, Screen parent, IModConfig config) {
        super((Component)Component.literal((String)"Request Screen"), customTexture);
        this.parent = parent;
        this.nav = nav;
        this.requestId = UUID.randomUUID();
        this.config = config.loadFromNetworking(this.requestId, T -> {
            this.result = T;
        });
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
    }

    @Override
    public void receiveConfigData(UUID requestId, FriendlyByteBuf buf) {
        if (!this.requestId.equals(requestId)) {
            return;
        }
        if (this.result == null) {
            return;
        }
        if (this.result.test(buf)) {
            this.minecraft.setScreen((Screen)new ConfigScreen(this.nav, this.config, this.parent, this.getCustomTexture()));
            return;
        }
        this.minecraft.setScreen(this.parent);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.tick;
        if (this.tick > 400) {
            this.minecraft.setScreen(this.parent);
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, REQUEST, this.width / 2, this.height / 2 - 12, -1);
        int index = this.tick / 5 % 8;
        if (index >= 5) {
            index = 8 - index;
        }
        graphics.drawCenteredString(this.font, ANIMATION[index], this.width / 2, this.height / 2, -1);
        int timeout = (401 - this.tick) / 20;
        if (timeout <= 18) {
            MutableComponent draw = Component.translatable((String)"gui.carbonconfig.timeout", (Object[])new Object[]{timeout}).withStyle(ChatFormatting.RED);
            graphics.drawCenteredString(this.font, (Component)draw, this.width / 2, this.height / 2 + 12, -1);
        }
    }
}

