/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.impl.minecraft.IGameRuleValue;
import carbonconfiglib.gui.impl.minecraft.MinecraftRoot;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.networking.minecraft.RequestGameRulesPacket;
import carbonconfiglib.networking.minecraft.SaveGameRulesPacket;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.DynamicOps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectLinkedOpenHashMap;

public class MinecraftConfig
implements IModConfig {
    public static final GameRules DEFAULTS = new GameRules();
    protected GameRules current;
    List<IGameRuleValue> values = new ObjectArrayList();
    Map<GameRules.Category, List<IGameRuleValue>> keys = new Object2ObjectLinkedOpenHashMap();

    public MinecraftConfig() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        this.setRules(server.getGameRules());
    }

    protected MinecraftConfig(GameRules current) {
        this.setRules(current);
    }

    protected void setRules(GameRules current) {
        this.current = current;
        this.collect();
    }

    private void collect() {
        GameRules.visitGameRuleTypes((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public void visitBoolean(GameRules.Key<GameRules.BooleanValue> key, GameRules.Type<GameRules.BooleanValue> type) {
                MinecraftConfig.this.add(key, IGameRuleValue.bool(key, (GameRules.BooleanValue)MinecraftConfig.this.current.getRule(key)));
            }

            public void visitInteger(GameRules.Key<GameRules.IntegerValue> key, GameRules.Type<GameRules.IntegerValue> type) {
                MinecraftConfig.this.add(key, IGameRuleValue.ints(key, (GameRules.IntegerValue)MinecraftConfig.this.current.getRule(key)));
            }
        });
    }

    private void add(GameRules.Key<?> key, IGameRuleValue value) {
        this.keys.computeIfAbsent(key.getCategory(), T -> new ObjectArrayList()).add(value);
        this.values.add(value);
    }

    @Override
    public String getFileName() {
        return "level.dat";
    }

    @Override
    public String getConfigName() {
        return "Game Rules";
    }

    @Override
    public String getModId() {
        return "minecraft";
    }

    @Override
    public boolean isDynamicConfig() {
        return true;
    }

    @Override
    public boolean isLocalConfig() {
        return ServerLifecycleHooks.getCurrentServer() != null;
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.SERVER;
    }

    @Override
    public IConfigNode getRootNode() {
        return new MinecraftRoot(this.keys);
    }

    @Override
    public boolean isDefault() {
        for (IGameRuleValue value : this.values) {
            if (Objects.equals(value.get(), value.getDefault())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void restoreDefault() {
        for (IGameRuleValue value : this.values) {
            value.set(value.getDefault());
        }
    }

    @Override
    public List<IModConfig.IConfigTarget> getPotentialFiles() {
        LevelStorageSource storage = Minecraft.getInstance().getLevelSource();
        ObjectArrayList folders = new ObjectArrayList();
        for (LevelSummary sum : (List)storage.loadLevelSummaries(storage.findLevelCandidates()).join()) {
            try {
                LevelStorageSource.LevelStorageAccess access = Minecraft.getInstance().getLevelSource().createAccess(sum.getLevelId());
                try {
                    Path path = access.getLevelPath(LevelResource.LEVEL_DATA_FILE);
                    if (Files.notExists(path, new LinkOption[0])) continue;
                    folders.add(new IModConfig.WorldConfigTarget(new PerWorldProxy.WorldTarget(sum, access.getLevelPath(LevelResource.ROOT), path), path));
                }
                finally {
                    if (access == null) continue;
                    access.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return folders;
    }

    @Override
    public boolean canCreateConfigs() {
        return false;
    }

    @Override
    public boolean createConfig(Path path) {
        return false;
    }

    @Override
    public IModConfig loadFromFile(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        try {
            return new FileConfig(path, NbtIo.readCompressed((Path)path, (NbtAccounter)NbtAccounter.unlimitedHeap()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IModConfig loadFromNetworking(UUID requestId, Consumer<Predicate<FriendlyByteBuf>> network) {
        NetworkConfig config = new NetworkConfig();
        network.accept(config);
        CarbonConfig.NETWORK.sendToServer(new RequestGameRulesPacket(requestId));
        return config;
    }

    @Override
    public void save() {
        if (this.current == null) {
            return;
        }
        this.current.assignFrom(this.current.copy(), ServerLifecycleHooks.getCurrentServer());
    }

    public static class FileConfig
    extends MinecraftConfig {
        Path file;
        CompoundTag tag;

        public FileConfig(Path file, CompoundTag tag) {
            super(new GameRules((DynamicLike)new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("Data").getCompound("GameRules"))));
            this.file = file;
            this.tag = tag;
        }

        @Override
        public void save() {
            this.tag.getCompound("Data").put("GameRules", (Tag)this.current.createTag());
            try {
                NbtIo.writeCompressed((CompoundTag)this.tag, (Path)this.file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class NetworkConfig
    extends MinecraftConfig
    implements Predicate<FriendlyByteBuf> {
        @Override
        public void save() {
            if (this.current == null) {
                return;
            }
            CarbonConfig.NETWORK.sendToServer(new SaveGameRulesPacket(this.current));
        }

        @Override
        public boolean test(FriendlyByteBuf buffer) {
            this.setRules(new GameRules((DynamicLike)new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)buffer.readNbt())));
            return true;
        }
    }
}

