/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.impl.minecraft.MinecraftConfig;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.ParseResult;
import net.minecraft.world.level.GameRules;

public interface IGameRuleValue {
    public void set(String var1);

    public ParseResult<Boolean> isValid(String var1);

    public String get();

    public String getDefault();

    public String getDescriptionId();

    public DataType getType();

    public static IGameRuleValue bool(GameRules.Key<GameRules.BooleanValue> key, GameRules.BooleanValue value) {
        return new BooleanEntry(key, value);
    }

    public static IGameRuleValue ints(GameRules.Key<GameRules.IntegerValue> key, GameRules.IntegerValue value) {
        return new IntegerEntry(key, value);
    }

    public static class BooleanEntry
    implements IGameRuleValue {
        GameRules.Key<GameRules.BooleanValue> key;
        GameRules.BooleanValue value;

        private BooleanEntry(GameRules.Key<GameRules.BooleanValue> key, GameRules.BooleanValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void set(String value) {
            this.value.set(Boolean.valueOf(value).booleanValue(), null);
        }

        @Override
        public ParseResult<Boolean> isValid(String value) {
            return ParseResult.success(true);
        }

        @Override
        public String get() {
            return String.valueOf(this.value.get());
        }

        @Override
        public String getDefault() {
            return String.valueOf(MinecraftConfig.DEFAULTS.getBoolean(this.key));
        }

        @Override
        public String getDescriptionId() {
            return this.key.getDescriptionId();
        }

        @Override
        public DataType getType() {
            return DataType.BOOLEAN;
        }
    }

    public static class IntegerEntry
    implements IGameRuleValue {
        GameRules.Key<GameRules.IntegerValue> key;
        GameRules.IntegerValue value;

        private IntegerEntry(GameRules.Key<GameRules.IntegerValue> key, GameRules.IntegerValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void set(String value) {
            ParseResult<Integer> result = Helpers.parseInt(value);
            if (result.isValid()) {
                this.value.set(result.getValue().intValue(), null);
            }
        }

        @Override
        public ParseResult<Boolean> isValid(String value) {
            ParseResult<Integer> result = Helpers.parseInt(value);
            return result.withDefault(result.isValid());
        }

        @Override
        public String get() {
            return String.valueOf(this.value.get());
        }

        @Override
        public String getDefault() {
            return String.valueOf(MinecraftConfig.DEFAULTS.getInt(this.key));
        }

        @Override
        public String getDescriptionId() {
            return this.key.getDescriptionId();
        }

        @Override
        public DataType getType() {
            return DataType.INTEGER;
        }
    }
}

