/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.screen.EditStringScreen;
import carbonconfiglib.gui.screen.ListSelectionScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.utils.ParseResult;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class EnumElement
extends ConfigElement {
    ParseResult<Boolean> result;

    public EnumElement(IValueNode value) {
        super(value);
    }

    public EnumElement(IArrayNode array, IValueNode value) {
        super(array, value);
    }

    public EnumElement(ICompoundNode compound, IValueNode value) {
        super(compound, value);
    }

    @Override
    public void init() {
        super.init();
        if (!this.hasSuggestions() || this.isArray() || this.isCompound()) {
            if (this.isArray()) {
                this.addChild(new CarbonButton(0, 0, 40, 18, (Component)Component.translatable((String)"gui.carbonconfig.edit"), this::onSelect), -32);
            } else {
                this.addChild(new CarbonButton(0, 0, 72, 18, (Component)Component.translatable((String)"gui.carbonconfig.edit"), this::onPress));
            }
        }
    }

    @Override
    protected int getMaxX(int prevMaxX) {
        return super.getMaxX(prevMaxX) - 140;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
        super.render(graphics, x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
        String value = this.value.get();
        if (this.isCompound()) {
            int offset = this.font.width(value) + 135;
            GuiUtils.drawScrollingString(graphics, this.font, (Component)Component.literal((String)value), left + width - offset, top, 135.0f, (float)height - 2.75f, ConfigElement.GuiAlign.LEFT, -1, 0);
        } else if (this.isArray()) {
            GuiUtils.drawScrollingString(graphics, this.font, (Component)Component.literal((String)value), left + (this.canMove() ? 5 : 10), top, 140.0f, (float)height - 2.75f, ConfigElement.GuiAlign.LEFT, -1, 0);
        } else {
            GuiUtils.drawScrollingString(graphics, this.font, (Component)Component.literal((String)value), left - 20, top, 140.0f, (float)height - 2.75f, ConfigElement.GuiAlign.LEFT, -1, 0);
        }
    }

    private void onSelect(Button button) {
        this.mc.setScreen((Screen)new ListSelectionScreen(this.mc.screen, this.value, ListSelectionScreen.NodeSupplier.ofValue(), this.owner.getCustomTexture()));
    }

    private void onPress(Button button) {
        this.mc.setScreen((Screen)new EditStringScreen(this.mc.screen, this.name, this.value, this.owner.getCustomTexture()));
    }
}

