/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.common;

import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class PotionTank
extends FluidTank {
    public static final double POTION_TO_MB = 2.5;
    public static final double MB_TO_POTION = 0.4;
    private final PotionJarTile jar;

    public PotionTank(PotionJarTile tile) {
        super((int)((double)tile.getMaxFill() * 2.5), stack -> stack.getFluid().isSame((Fluid)AllFluids.POTION.getSource()));
        this.jar = tile;
    }

    public boolean isFluidValid(FluidStack stack) {
        return super.isFluidValid(stack) && stack.has(DataComponents.POTION_CONTENTS) && this.jar.canAccept((PotionContents)stack.get(DataComponents.POTION_CONTENTS), 1);
    }

    @NotNull
    public FluidStack getFluid() {
        return PotionFluidHandler.getFluidFromPotion((PotionContents)this.jar.getData(), (PotionFluid.BottleType)PotionFluid.BottleType.REGULAR, (int)this.getFluidAmount());
    }

    public boolean isEmpty() {
        return this.jar.getAmount() <= 0;
    }

    public int getFluidAmount() {
        return (int)((double)this.jar.getAmount() * 2.5);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        PotionContents data = (PotionContents)resource.get(DataComponents.POTION_CONTENTS);
        if (!this.jar.canAccept(data, resource.getAmount())) {
            return 0;
        }
        if (action.simulate()) {
            if (this.jar.getAmount() <= 0) {
                return Math.min(this.capacity, resource.getAmount());
            }
            return Math.min(this.capacity - this.getFluidAmount(), resource.getAmount());
        }
        if (this.jar.getAmount() <= 0) {
            int amountToAdd = Mth.ceil((double)((double)resource.getAmount() * 0.4));
            if (amountToAdd > 0) {
                this.jar.add(data, amountToAdd);
                return resource.getAmount();
            }
            return 0;
        }
        int filled = this.capacity - this.getFluidAmount();
        int amountToAdd = Mth.ceil((double)((double)resource.getAmount() * 0.4));
        if (amountToAdd > 0) {
            this.jar.add(data, amountToAdd);
            if (resource.getAmount() < filled) {
                filled = resource.getAmount();
            }
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.getFluidAmount() < drained) {
            drained = this.getFluidAmount();
        }
        FluidStack stack = PotionFluidHandler.getFluidFromPotion((PotionContents)this.jar.getData(), (PotionFluid.BottleType)PotionFluid.BottleType.REGULAR, (int)drained);
        if (action.execute() && drained > 0) {
            this.jar.remove(Mth.ceil((double)((double)drained * 0.4)));
        }
        return stack;
    }
}

