/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgykubejs;

import com.google.common.base.Suppliers;
import com.klikli_dev.theurgy.content.item.niter.AlchemicalNiterItem;
import com.klikli_dev.theurgy.tooltips.TooltipHandler;
import com.klikli_dev.theurgykubejs.AlchemicalDerivativeItemType;
import com.klikli_dev.theurgykubejs.TheurgyKubeJS;
import dev.latvian.mods.kubejs.client.LangKubeEvent;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public class AlchemicalNiterItemType
extends AlchemicalDerivativeItemType {
    public AlchemicalNiterItemType(ResourceLocation rl) {
        super(rl);
        this.jarIcon(ResourceLocation.fromNamespaceAndPath((String)"theurgy", (String)"empty_ceramic_jar_icon"));
    }

    public Item createObject() {
        AlchemicalNiterItem item = new AlchemicalNiterItem(this.decorateWithSource(this.createItemProperties()), this.derivativeTier);
        item.useCustomSourceName(true).autoTooltip(this.provideDerivativeInformationAsTooltipParam, false).autoName(this.provideDerivativeInformationAsNameParam, false).withJarIcon((Supplier)Suppliers.memoize(() -> new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.jarIcon))));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            TooltipHandler.registerTooltipDataProvider((Item)item, arg_0 -> ((AlchemicalNiterItem)item).getTooltipData(arg_0));
            TheurgyKubeJS.Client.registerAlchemicalDerivativeItem((Item)item);
        }
        return item;
    }

    @Info(value="Sets the item that will be used as icon for the niter. Ideally a dummy item with a fitting icon should be created for this purpose. Normal KubeJS items can be used for this.")
    public ItemBuilder niterIcon(ResourceLocation id) {
        return this.sourceItem(id);
    }

    @Override
    public void generateLang(LangKubeEvent lang) {
        super.generateLang(lang);
        if (this.generateNameLangEntry) {
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey(), "Alchemical Niter %s");
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey() + ".source", this.sourceName);
        }
        if (this.generateTooltipLangEntry) {
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey() + ".tooltip", "Alchemical Niter is crafted from Alchemical Sulfur of any %s.");
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey() + ".tooltip.extended", "Niter represents the abstract category and value of an object, thus it is a further abstraction the \"idea\" or \"soul\" represented by Sulfur.");
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey() + ".tooltip.usage", "Niter extraction is a required intermediate step to transform one type of Sulfur into another type.");
        }
    }
}

