/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.neoforge.component;

import com.iafenvoy.uranus.neoforge.component.CapabilitySyncPayload;
import com.iafenvoy.uranus.neoforge.component.IAttachment;
import com.iafenvoy.uranus.neoforge.component.ITickableAttachment;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class CapabilitySyncHelper {
    public static final ResourceLocation CAPABILITY_SYNC = ResourceLocation.fromNamespaceAndPath((String)"uranus", (String)"capability_sync");
    private static final List<AttachmentType<? extends IAttachment>> LIVINGS = new ArrayList<AttachmentType<? extends IAttachment>>();
    private static final List<PlayerCapabilityHolder<? extends IAttachment>> PLAYERS = new ArrayList<PlayerCapabilityHolder<? extends IAttachment>>();

    public static <T extends IAttachment> void registerForLiving(AttachmentType<T> capability) {
        LIVINGS.add(capability);
    }

    public static <T extends IAttachment> void registerForPlayer(ResourceLocation id, AttachmentType<T> capability) {
        PLAYERS.add(new PlayerCapabilityHolder<T>(id, capability));
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (PlayerCapabilityHolder playerCapabilityHolder : PLAYERS) {
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new CapabilitySyncPayload(playerCapabilityHolder.id, ((IAttachment)serverPlayer.getData(playerCapabilityHolder.attachmentType)).serializeNBT()));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (AttachmentType attachmentType : LIVINGS) {
                Object object = living.getData(attachmentType);
                if (!(object instanceof ITickableAttachment)) continue;
                ITickableAttachment tickable = (ITickableAttachment)object;
                tickable.tick();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        for (PlayerCapabilityHolder<? extends IAttachment> holder : PLAYERS) {
            Object object = player.getData(holder.attachmentType);
            if (!(object instanceof ITickableAttachment)) continue;
            ITickableAttachment attachment = (ITickableAttachment)object;
            attachment.tick();
            if (!attachment.isDirty() || !(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new CapabilitySyncPayload(holder.id, attachment.serializeNBT()));
        }
    }

    static {
        if (Platform.getEnv() == Dist.DEDICATED_SERVER) {
            NetworkManager.registerS2CPayloadType(CapabilitySyncPayload.ID, CapabilitySyncPayload.CODEC);
        }
    }

    public static class PlayerCapabilityHolder<T> {
        private final ResourceLocation id;
        private final AttachmentType<T> attachmentType;

        public PlayerCapabilityHolder(ResourceLocation id, AttachmentType<T> attachmentType) {
            this.id = id;
            this.attachmentType = attachmentType;
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void init(FMLClientSetupEvent event) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CapabilitySyncPayload.ID, CapabilitySyncPayload.CODEC, (payload, ctx) -> PLAYERS.stream().filter(x -> x.id.equals((Object)payload.id())).findFirst().ifPresent(holder -> ctx.queue(() -> {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    ((IAttachment)player.getData(holder.attachmentType)).deserializeNBT(payload.compound());
                }
            })));
        }
    }
}

