/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.viewer;

import com.almostreliable.unified.compat.viewer.CRTLookup;
import com.almostreliable.unified.compat.viewer.ClientRecipeTracker;
import com.almostreliable.unified.compat.viewer.ItemHider;
import com.almostreliable.unified.compat.viewer.RecipeIndicator;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeDecorator;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@EmiEntrypoint
public class AlmostEMI
implements EmiPlugin {
    public void initialize(EmiInitRegistry registry) {
        if (!BuiltInRegistries.ITEM.getTagOrEmpty(ItemHider.EMI_STRICT_TAG).iterator().hasNext()) {
            return;
        }
        for (Holder itemHolder : BuiltInRegistries.ITEM.getTagOrEmpty(ItemHider.HIDE_TAG)) {
            registry.disableStack(EmiStack.of((ItemStack)new ItemStack(itemHolder)));
        }
    }

    public void register(EmiRegistry registry) {
        registry.addRecipeDecorator((EmiRecipeDecorator)new IndicatorDecorator());
        if (BuiltInRegistries.ITEM.getTagOrEmpty(ItemHider.EMI_STRICT_TAG).iterator().hasNext()) {
            return;
        }
        for (Holder itemHolder : BuiltInRegistries.ITEM.getTagOrEmpty(ItemHider.HIDE_TAG)) {
            registry.removeEmiStacks(EmiStack.of((ItemStack)new ItemStack(itemHolder)));
        }
    }

    private static class IndicatorDecorator
    implements EmiRecipeDecorator {
        private IndicatorDecorator() {
        }

        public void decorateRecipe(EmiRecipe recipe, WidgetHolder widgets) {
            ResourceLocation recipeId = recipe.getId();
            if (recipeId == null) {
                return;
            }
            ClientRecipeTracker.ClientRecipeLink link = CRTLookup.getLink(recipeId);
            if (link == null) {
                return;
            }
            int pX = recipe.getDisplayWidth() - 5;
            int pY = recipe.getDisplayHeight() - 3;
            int size = 9;
            widgets.addDrawable(0, 0, 0, 0, (guiGraphics, mX, mY, delta) -> RecipeIndicator.renderIndicator(guiGraphics, pX, pY, size));
            widgets.addTooltipText(RecipeIndicator.constructTooltip(link), pX, pY, size, size);
        }
    }
}

