/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.vampiresneedumbrellas.handlers;

import com.focamacho.vampiresneedumbrellas.config.ConfigHolder;
import com.focamacho.vampiresneedumbrellas.handlers.CuriosHandler;
import com.focamacho.vampiresneedumbrellas.potions.SunscreenEffectInstance;
import com.focamacho.vampiresneedumbrellas.utils.Utils;
import de.teamlapen.vampirism.api.VReference;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import top.theillusivec4.curios.api.SlotResult;

public class VampirismHandler {
    public static Holder<MobEffect> vampirism_sunscreen = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)"vampirism:sunscreen")).orElse(null);

    public static void applyEffect(ItemStack stack, Level world, Entity entityIn, boolean breakable) {
        if (VampirismHandler.canApplyEffect(entityIn)) {
            Optional<SlotResult> opt;
            Player player = (Player)entityIn;
            if (ConfigHolder.umbrellaMainHand && player.getMainHandItem().equals(stack) || ConfigHolder.umbrellaOffHand && player.getOffhandItem().equals(stack)) {
                player.addEffect((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
                if (breakable && VReference.VAMPIRE_FACTION.getPlayerCapability(player).map(v -> v.isGettingSundamage((LevelAccessor)world)).orElse(false).booleanValue()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                }
                return;
            }
            if (Utils.isCuriosLoaded && (opt = CuriosHandler.getUmbrellaEquiped(stack, player)).isPresent()) {
                SlotResult umbrella = opt.get();
                player.addEffect((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
                if (breakable && VReference.VAMPIRE_FACTION.getPlayerCapability(player).map(v -> v.isGettingSundamage((LevelAccessor)world)).orElse(false).booleanValue()) {
                    String id = umbrella.slotContext().identifier();
                    int index = umbrella.slotContext().index();
                    if (player.level() instanceof ServerLevel) {
                        stack.hurtAndBreak(1, (ServerLevel)player.level(), (LivingEntity)player, item -> CuriosHandler.onBrokenCurio(id, index, player));
                    }
                }
            }
        }
    }

    public static void applyCreativeEffect(ItemStack stack, Entity entityIn) {
        if (VampirismHandler.canApplyEffect(entityIn)) {
            Player player = (Player)entityIn;
            if (ConfigHolder.creativeUmbrellaConfigs && (ConfigHolder.umbrellaMainHand && player.getMainHandItem().equals(stack) || ConfigHolder.umbrellaOffHand && player.getOffhandItem().equals(stack))) {
                player.addEffect((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
            } else if (player.getMainHandItem().equals(stack) || player.getOffhandItem().equals(stack) || Utils.isCuriosLoaded && CuriosHandler.getUmbrellaEquiped(stack, player).isPresent()) {
                player.addEffect((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
            } else if (Utils.isCuriosLoaded && CuriosHandler.getUmbrellaEquiped(stack, player).isPresent()) {
                player.addEffect((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
            }
        }
    }

    private static boolean canApplyEffect(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        MobEffectInstance effectInstance = player.getEffect(vampirism_sunscreen);
        return effectInstance == null || effectInstance.getDuration() <= 1;
    }
}

