/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.reward.storage;

import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.reward.storage.EnabledRewards;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class RewardWorldStorage
extends SavedData {
    public static final SavedData.Factory<RewardWorldStorage> FACTORY = new SavedData.Factory(RewardWorldStorage::new, (compoundTag, prov) -> new RewardWorldStorage().load((CompoundTag)compoundTag, (HolderLookup.Provider)prov));
    public static String NAME = "TitaniumReward";
    private HashMap<UUID, EnabledRewards> rewards = new HashMap();
    private List<ResourceLocation> freeRewards = new ArrayList<ResourceLocation>();
    private List<UUID> configuredPlayers = new ArrayList<UUID>();

    private RewardWorldStorage() {
    }

    public static RewardWorldStorage get(ServerLevel world) {
        return (RewardWorldStorage)world.getDataStorage().computeIfAbsent(FACTORY, NAME);
    }

    public void remove(UUID uuid, ResourceLocation resourceLocation) {
        this.rewards.computeIfAbsent(uuid, uuid1 -> new EnabledRewards()).getEnabled().remove(resourceLocation);
    }

    public void add(UUID uuid, ResourceLocation resourceLocation, String option) {
        this.rewards.computeIfAbsent(uuid, uuid1 -> new EnabledRewards()).getEnabled().put(resourceLocation, option);
    }

    public void addFree(ResourceLocation resourceLocation) {
        this.freeRewards.add(resourceLocation);
    }

    public List<ResourceLocation> getFreeRewards() {
        return this.freeRewards;
    }

    public List<UUID> getConfiguredPlayers() {
        return this.configuredPlayers;
    }

    public RewardWorldStorage load(CompoundTag nbt, HolderLookup.Provider provider) {
        CompoundTag compoundNBT = nbt.getCompound(NAME);
        this.rewards.clear();
        compoundNBT.getAllKeys().forEach(s -> {
            EnabledRewards rewards = new EnabledRewards();
            rewards.deserializeNBT(provider, compoundNBT.getCompound(s));
            this.rewards.put(UUID.fromString(s), rewards);
        });
        this.freeRewards.clear();
        CompoundTag free = nbt.getCompound("FreeRewards");
        free.getAllKeys().forEach(s -> this.freeRewards.add(ResourceLocation.parse((String)s)));
        this.configuredPlayers.clear();
        CompoundTag configured = nbt.getCompound("ConfiguredPlayers");
        configured.getAllKeys().forEach(s -> this.configuredPlayers.add(UUID.fromString(s)));
        HashMap<UUID, ResourceLocation> toRemove = new HashMap<UUID, ResourceLocation>();
        RewardManager.get().getRewards().forEach((uuid, rewardGiver) -> rewardGiver.getRewards().forEach(reward -> {
            for (UUID configuredPlayer : this.rewards.keySet()) {
                if (reward.isPlayerValid(configuredPlayer)) continue;
                toRemove.put(configuredPlayer, reward.getResourceLocation());
            }
        }));
        toRemove.forEach(this::remove);
        return this;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        this.rewards.forEach((uuid, enabledRewards) -> compoundNBT.put(uuid.toString(), (Tag)enabledRewards.serializeNBT(provider)));
        compound.put(NAME, (Tag)compoundNBT);
        CompoundTag free = new CompoundTag();
        this.freeRewards.forEach(resourceLocation -> free.putBoolean(resourceLocation.toString(), true));
        compound.put("FreeRewards", (Tag)free);
        CompoundTag configured = new CompoundTag();
        this.configuredPlayers.forEach(uuid -> configured.putBoolean(uuid.toString(), true));
        compound.put("ConfiguredPlayers", (Tag)configured);
        return compound;
    }

    public CompoundTag serializeSimple(HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        this.rewards.forEach((uuid, enabledRewards) -> compoundNBT.put(uuid.toString(), (Tag)enabledRewards.serializeNBT(provider)));
        return compoundNBT;
    }
}

