/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import com.mojang.serialization.MapCodec;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleToolDurability;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.impl.upgrades.TurtleToolSpec;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.WorldUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class TurtleTool
extends AbstractTurtleUpgrade {
    public static final MapCodec<TurtleTool> CODEC = TurtleToolSpec.CODEC.xmap(TurtleTool::new, x -> x.spec);
    private static final TurtleCommandResult UNBREAKABLE = TurtleCommandResult.failure("Cannot break unbreakable block");
    private static final TurtleCommandResult INEFFECTIVE = TurtleCommandResult.failure("Cannot break block with this tool");
    final TurtleToolSpec spec;
    final @Nullable TagKey<Block> breakable;

    public TurtleTool(TurtleToolSpec spec) {
        super(TurtleUpgradeType.TOOL, spec.adjective(), new ItemStack((ItemLike)spec.item()));
        this.spec = spec;
        this.breakable = spec.breakable().orElse(null);
    }

    @Override
    public boolean isItemSuitable(ItemStack stack) {
        if (this.spec.consumeDurability() == TurtleToolDurability.NEVER && stack.isDamaged()) {
            return false;
        }
        return this.spec.allowEnchantments() || !TurtleTool.isEnchanted(stack);
    }

    private static boolean isEnchanted(ItemStack stack) {
        DataComponentPatch patch = stack.getComponentsPatch();
        return DataComponentUtil.isPresent(patch, DataComponents.ENCHANTMENTS, x -> !x.isEmpty()) || DataComponentUtil.isPresent(patch, DataComponents.ATTRIBUTE_MODIFIERS, x -> !x.modifiers().isEmpty());
    }

    @Override
    public DataComponentPatch getUpgradeData(ItemStack stack) {
        return stack.getComponentsPatch();
    }

    @Override
    public ItemStack getUpgradeItem(DataComponentPatch upgradeData) {
        ItemStack item = super.getUpgradeItem(upgradeData).copy();
        item.applyComponents(upgradeData);
        return item;
    }

    private ItemStack getToolStack(ITurtleAccess turtle, TurtleSide side) {
        return this.getUpgradeItem(turtle.getUpgradeData(side));
    }

    private void setToolStack(ITurtleAccess turtle, TurtleSide side, ItemStack oldStack, ItemStack stack) {
        boolean useDurability;
        switch (this.spec.consumeDurability()) {
            default: {
                throw new MatchException(null, null);
            }
            case NEVER: {
                boolean bl = false;
                break;
            }
            case WHEN_ENCHANTED: {
                boolean bl = TurtleTool.isEnchanted(oldStack);
                break;
            }
            case ALWAYS: {
                boolean bl = useDurability = true;
            }
        }
        if (!useDurability) {
            return;
        }
        if (stack.isEmpty()) {
            turtle.setUpgrade(side, null);
            return;
        }
        if (stack.getItem() != this.spec.item()) {
            return;
        }
        turtle.setUpgradeData(side, stack.getComponentsPatch());
    }

    private <T> T withEquippedItem(ITurtleAccess turtle, TurtleSide side, Direction direction, Function<TurtlePlayer, T> action) {
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, turtle.getPosition(), direction);
        ItemStack stack = this.getToolStack(turtle, side);
        turtlePlayer.loadInventory(stack.copy());
        T result = action.apply(turtlePlayer);
        this.setToolStack(turtle, side, stack, turtlePlayer.player().getItemInHand(InteractionHand.MAIN_HAND));
        turtlePlayer.player().getInventory().clearContent();
        return result;
    }

    @Override
    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, Direction direction) {
        return switch (verb) {
            default -> throw new MatchException(null, null);
            case TurtleVerb.ATTACK -> this.attack(turtle, side, direction);
            case TurtleVerb.DIG -> this.dig(turtle, side, direction);
        };
    }

    protected TurtleCommandResult checkBlockBreakable(Level world, BlockPos pos, TurtlePlayer player) {
        BlockState state = world.getBlockState(pos);
        if (state.isAir() || state.getBlock() instanceof GameMasterBlock || state.getDestroyProgress((Player)player.player(), (BlockGetter)world, pos) <= 0.0f) {
            return UNBREAKABLE;
        }
        return this.breakable == null || state.is(this.breakable) || TurtleTool.isTriviallyBreakable((BlockGetter)world, pos, state) ? TurtleCommandResult.success() : INEFFECTIVE;
    }

    private TurtleCommandResult attack(ITurtleAccess turtle, TurtleSide side, Direction direction) {
        Level world = turtle.getLevel();
        BlockPos position = turtle.getPosition();
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, position, direction);
        ServerPlayer player = turtlePlayer.player();
        Vec3 turtlePos = player.position();
        Vec3 rayDir = player.getViewVector(1.0f);
        HitResult hit = WorldUtil.clip(world, turtlePos, rayDir, 1.5, null);
        boolean attacked = false;
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            ItemStack stack = this.getToolStack(turtle, side);
            turtlePlayer.loadInventory(stack.copy());
            Entity hitEntity = entityHit.getEntity();
            DropConsumer.set(hitEntity, TurtleUtil.dropConsumer(turtle));
            InteractionResult result = PlatformHelper.get().canAttackEntity(player, hitEntity);
            if (result.consumesAction()) {
                attacked = true;
            } else if (result == InteractionResult.PASS && hitEntity.isAttackable() && !hitEntity.skipAttackInteraction((Entity)player)) {
                attacked = this.attack(player, direction, hitEntity);
            }
            TurtleUtil.stopConsuming(turtle);
            this.setToolStack(turtle, side, stack, player.getItemInHand(InteractionHand.MAIN_HAND));
            player.getInventory().clearContent();
        }
        return attacked ? TurtleCommandResult.success() : TurtleCommandResult.failure("Nothing to attack here");
    }

    private boolean attack(ServerPlayer player, Direction direction, Entity entity) {
        LivingEntity target;
        float knockBack;
        Projectile projectile;
        float baseDamage = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE) * this.spec.damageMultiplier();
        ItemStack tool = player.getWeaponItem();
        DamageSource source = player.damageSources().playerAttack((Player)player);
        float bonusDamage = EnchantmentHelper.modifyDamage((ServerLevel)player.serverLevel(), (ItemStack)tool, (Entity)entity, (DamageSource)source, (float)baseDamage) - baseDamage;
        if (entity.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && entity instanceof Projectile && (projectile = (Projectile)entity).deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)player, (Entity)player, true)) {
            return true;
        }
        if (baseDamage <= 0.0f && bonusDamage <= 0.0f) {
            return false;
        }
        Vec3 entityVelocity = entity.getDeltaMovement();
        float damage = baseDamage + bonusDamage + tool.getItem().getAttackDamageBonus(entity, baseDamage, source);
        if (!entity.hurt(source, damage)) {
            return false;
        }
        if (entity.isAlive() && entity instanceof ArmorStand) {
            entity.hurt(source, damage);
        }
        if ((knockBack = EnchantmentHelper.modifyKnockback((ServerLevel)player.serverLevel(), (ItemStack)tool, (Entity)entity, (DamageSource)source, (float)((float)player.getAttributeValue(Attributes.ATTACK_KNOCKBACK)))) > 0.0f) {
            if (entity instanceof LivingEntity) {
                LivingEntity target2 = (LivingEntity)entity;
                target2.knockback((double)knockBack * 0.5, (double)(-direction.getStepX()), (double)(-direction.getStepZ()));
            } else {
                entity.push((double)((float)direction.getStepX() * knockBack) * 0.5, 0.1, (double)((float)direction.getStepZ() * knockBack) * 0.5);
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)entity;
            if (entity.hurtMarked) {
                otherPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket(entity));
                entity.hurtMarked = false;
                entity.setDeltaMovement(entityVelocity);
            }
        }
        boolean didHurt = entity instanceof LivingEntity && tool.hurtEnemy(target = (LivingEntity)entity, (Player)player);
        EnchantmentHelper.doPostAttackEffects((ServerLevel)player.serverLevel(), (Entity)entity, (DamageSource)source);
        if (!tool.isEmpty() && entity instanceof LivingEntity && didHurt) {
            tool.postHurtEnemy((LivingEntity)entity, (Player)player);
        }
        return true;
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, TurtleSide side, Direction direction) {
        ServerLevel level = (ServerLevel)turtle.getLevel();
        return this.withEquippedItem(turtle, side, direction, turtlePlayer -> {
            ItemStack stack = turtlePlayer.player().getItemInHand(InteractionHand.MAIN_HAND);
            if (PlatformHelper.get().hasToolUsage(stack) && TurtleTool.useTool(level, turtle, turtlePlayer, stack, direction)) {
                return TurtleCommandResult.success();
            }
            BlockPos blockPosition = turtle.getPosition().relative(direction);
            if (level.isEmptyBlock(blockPosition) || WorldUtil.isLiquidBlock((Level)level, blockPosition)) {
                return TurtleCommandResult.failure("Nothing to dig here");
            }
            TurtleCommandResult breakable = this.checkBlockBreakable((Level)level, blockPosition, (TurtlePlayer)turtlePlayer);
            if (!breakable.isSuccess()) {
                return breakable;
            }
            DropConsumer.set((Level)level, blockPosition, TurtleUtil.dropConsumer(turtle));
            boolean broken = !turtlePlayer.isBlockProtected(level, blockPosition) && turtlePlayer.player().gameMode.destroyBlock(blockPosition);
            TurtleUtil.stopConsuming(turtle);
            return broken ? TurtleCommandResult.success() : TurtleCommandResult.failure("Cannot break protected block");
        });
    }

    private static boolean useTool(ServerLevel level, ITurtleAccess turtle, TurtlePlayer turtlePlayer, ItemStack stack, Direction direction) {
        PlatformHelper.UseOnResult result;
        BlockPos position = turtle.getPosition().relative(direction);
        if (direction == Direction.DOWN && level.isEmptyBlock(position)) {
            position = position.relative(direction);
        }
        if (!level.isInWorldBounds(position) || level.isEmptyBlock(position) || turtlePlayer.isBlockProtected(level, position)) {
            return false;
        }
        BlockHitResult hit = TurtlePlaceCommand.getHitResult(position, direction.getOpposite());
        PlatformHelper.UseOnResult useOnResult = result = PlatformHelper.get().useOn(turtlePlayer.player(), stack, hit);
        Objects.requireNonNull(useOnResult);
        PlatformHelper.UseOnResult useOnResult2 = useOnResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlatformHelper.UseOnResult.Handled.class, PlatformHelper.UseOnResult.Continue.class}, (Object)useOnResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PlatformHelper.UseOnResult.Handled handled = (PlatformHelper.UseOnResult.Handled)useOnResult2;
                yield handled.result().consumesAction();
            }
            case 1 -> {
                PlatformHelper.UseOnResult.Continue canUse = (PlatformHelper.UseOnResult.Continue)useOnResult2;
                yield canUse.item() && stack.useOn(new UseOnContext((Player)turtlePlayer.player(), InteractionHand.MAIN_HAND, hit)).consumesAction();
            }
        };
    }

    private static boolean isTriviallyBreakable(BlockGetter reader, BlockPos pos, BlockState state) {
        return state.is(ComputerCraftTags.Blocks.TURTLE_ALWAYS_BREAKABLE) || state.getDestroySpeed(reader, pos) == 0.0f;
    }

    public UpgradeType<TurtleTool> getType() {
        return (UpgradeType)ModRegistry.TurtleUpgradeTypes.TOOL.get();
    }
}

