/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class TurtleModem
extends AbstractTurtleUpgrade {
    public static final MapCodec<TurtleModem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(x -> x.getCraftingItem().getItem()), (App)Codec.BOOL.fieldOf("advanced").forGetter(TurtleModem::advanced)).apply((Applicative)instance, (item, advanced) -> new TurtleModem(new ItemStack((ItemLike)item), (boolean)advanced)));
    private final boolean advanced;

    public TurtleModem(ItemStack stack, boolean advanced) {
        super(TurtleUpgradeType.PERIPHERAL, advanced ? "upgrade.computercraft.wireless_modem_advanced.adjective" : "upgrade.computercraft.wireless_modem_normal.adjective", stack);
        this.advanced = advanced;
    }

    public boolean advanced() {
        return this.advanced;
    }

    @Override
    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new Peripheral(turtle, this.advanced);
    }

    @Override
    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, Direction dir) {
        return TurtleCommandResult.failure();
    }

    @Override
    public void update(ITurtleAccess turtle, TurtleSide side) {
        Peripheral modem;
        ModemState state;
        IPeripheral peripheral;
        if (!turtle.getLevel().isClientSide && (peripheral = turtle.getPeripheral(side)) instanceof Peripheral && (state = (modem = (Peripheral)peripheral).getModemState()).pollChanged()) {
            turtle.setUpgradeData(side, DataComponentPatch.builder().set((DataComponentType)ModRegistry.DataComponents.ON.get(), (Object)state.isOpen()).build());
        }
    }

    @Override
    public DataComponentPatch getPersistedData(DataComponentPatch upgradeData) {
        return DataComponentPatch.EMPTY;
    }

    public UpgradeType<TurtleModem> getType() {
        return (UpgradeType)ModRegistry.TurtleUpgradeTypes.WIRELESS_MODEM.get();
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle, boolean advanced) {
            super(new ModemState(), advanced);
            this.turtle = turtle;
        }

        @Override
        public Level getLevel() {
            return this.turtle.getLevel();
        }

        @Override
        public Vec3 getPosition() {
            BlockPos turtlePos = this.turtle.getPosition();
            return new Vec3((double)turtlePos.getX(), (double)turtlePos.getY(), (double)turtlePos.getZ());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof Peripheral)) return false;
            Peripheral modem = (Peripheral)other;
            if (modem.turtle != this.turtle) return false;
            return true;
        }
    }
}

