/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.util.PeripheralHelpers;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.core.TurtleAccessInternal;
import dan200.computercraft.shared.turtle.core.TurtleCommandQueueEntry;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.NBTUtil;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class TurtleBrain
implements TurtleAccessInternal {
    public static final String NBT_FUEL = "Fuel";
    public static final String NBT_OVERLAY = "Overlay";
    public static final String NBT_COLOUR = "Color";
    public static final String NBT_LEFT_UPGRADE = "LeftUpgrade";
    public static final String NBT_RIGHT_UPGRADE = "RightUpgrade";
    private static final String NBT_SLOT = "Slot";
    private static final int ANIM_DURATION = 8;
    private TurtleBlockEntity owner;
    private @Nullable GameProfile owningPlayer;
    private final Container inventory = () -> this.owner;
    private final Queue<TurtleCommandQueueEntry> commandQueue = new ArrayDeque<TurtleCommandQueueEntry>();
    private int commandsIssued = 0;
    private final UpgradeInstance[] upgrades = new UpgradeInstance[]{new UpgradeInstance(), new UpgradeInstance()};
    private int selectedSlot = 0;
    private int fuelLevel = 0;
    private int colourHex = -1;
    private @Nullable Holder<TurtleOverlay> overlay = null;
    private TurtleAnimation animation = TurtleAnimation.NONE;
    private int animationProgress = 0;
    private int lastAnimationProgress = 0;
    @Nullable TurtlePlayer cachedPlayer;

    public TurtleBrain(TurtleBlockEntity turtle) {
        this.owner = turtle;
    }

    public void setOwner(TurtleBlockEntity owner) {
        this.owner = owner;
    }

    public TurtleBlockEntity getOwner() {
        return this.owner;
    }

    public ComputerFamily getFamily() {
        return this.owner.getFamily();
    }

    public void setupComputer(ServerComputer computer) {
        this.updatePeripherals(computer);
    }

    public void update() {
        Level world = this.getLevel();
        if (!world.isClientSide) {
            this.updateCommands();
            if (this.owner.isRemoved()) {
                return;
            }
        }
        this.updateAnimation();
        for (TurtleSide side : TurtleSide.values()) {
            Holder.Reference<ITurtleUpgrade> upgrade = this.upgrades[side.ordinal()].upgrade;
            if (upgrade == null) continue;
            ((ITurtleUpgrade)upgrade.value()).update(this, side);
        }
    }

    private void readCommon(CompoundTag nbt, HolderLookup.Provider registries) {
        this.colourHex = nbt.contains(NBT_COLOUR) ? nbt.getInt(NBT_COLOUR) : -1;
        this.fuelLevel = nbt.contains(NBT_FUEL) ? nbt.getInt(NBT_FUEL) : 0;
        this.overlay = nbt.contains(NBT_OVERLAY) ? NBTUtil.decodeFrom(TurtleOverlay.CODEC, registries, nbt, NBT_OVERLAY) : null;
        this.setUpgradeDirect(TurtleSide.LEFT, NBTUtil.decodeFrom(TurtleUpgrades.instance().upgradeDataCodec(), registries, nbt, NBT_LEFT_UPGRADE));
        this.setUpgradeDirect(TurtleSide.RIGHT, NBTUtil.decodeFrom(TurtleUpgrades.instance().upgradeDataCodec(), registries, nbt, NBT_RIGHT_UPGRADE));
    }

    private void writeCommon(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putInt(NBT_FUEL, this.fuelLevel);
        if (this.colourHex != -1) {
            nbt.putInt(NBT_COLOUR, this.colourHex);
        }
        if (this.overlay != null) {
            NBTUtil.encodeTo(TurtleOverlay.CODEC, registries, nbt, NBT_OVERLAY, this.overlay);
        }
        NBTUtil.encodeTo(TurtleUpgrades.instance().upgradeDataCodec(), registries, nbt, NBT_LEFT_UPGRADE, this.getUpgradeWithData(TurtleSide.LEFT));
        NBTUtil.encodeTo(TurtleUpgrades.instance().upgradeDataCodec(), registries, nbt, NBT_RIGHT_UPGRADE, this.getUpgradeWithData(TurtleSide.RIGHT));
    }

    public void readFromNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        this.readCommon(nbt, registries);
        this.selectedSlot = nbt.getInt(NBT_SLOT);
        if (nbt.contains("Owner", 10)) {
            CompoundTag owner = nbt.getCompound("Owner");
            this.owningPlayer = new GameProfile(new UUID(owner.getLong("UpperId"), owner.getLong("LowerId")), owner.getString("Name"));
        } else {
            this.owningPlayer = null;
        }
    }

    public void writeToNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        this.writeCommon(nbt, registries);
        nbt.putInt(NBT_SLOT, this.selectedSlot);
        if (this.owningPlayer != null) {
            CompoundTag owner = new CompoundTag();
            nbt.put("Owner", (Tag)owner);
            owner.putLong("UpperId", this.owningPlayer.getId().getMostSignificantBits());
            owner.putLong("LowerId", this.owningPlayer.getId().getLeastSignificantBits());
            owner.putString("Name", this.owningPlayer.getName());
        }
    }

    public void readDescription(CompoundTag nbt, HolderLookup.Provider registries) {
        this.readCommon(nbt, registries);
        TurtleAnimation anim = TurtleAnimation.values()[nbt.getInt("Animation")];
        if (anim != this.animation && anim != TurtleAnimation.WAIT && anim != TurtleAnimation.SHORT_WAIT && anim != TurtleAnimation.NONE) {
            this.animation = anim;
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
    }

    public void writeDescription(CompoundTag nbt, HolderLookup.Provider registries) {
        this.writeCommon(nbt, registries);
        nbt.putInt("Animation", this.animation.ordinal());
    }

    @Override
    public Level getLevel() {
        return this.owner.getLevel();
    }

    @Override
    public BlockPos getPosition() {
        return this.owner.getBlockPos();
    }

    @Override
    public boolean isRemoved() {
        return this.owner.isRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean teleportTo(Level world, BlockPos pos) {
        if (world.isClientSide || this.getLevel().isClientSide) {
            throw new UnsupportedOperationException("Cannot teleport on the client");
        }
        Level oldWorld = this.getLevel();
        TurtleBlockEntity oldOwner = this.owner;
        BlockPos oldPos = this.owner.getBlockPos();
        BlockState oldBlock = this.owner.getBlockState();
        if (oldWorld == world && oldPos.equals((Object)pos)) {
            return true;
        }
        if (!world.isLoaded(pos)) {
            return false;
        }
        if (!world.getWorldBorder().isWithinBounds(pos)) {
            return false;
        }
        FluidState existingFluid = world.getBlockState(pos).getFluidState();
        BlockState newState = (BlockState)oldBlock.setValue((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(existingFluid.is(FluidTags.WATER) && existingFluid.isSource()));
        oldOwner.notifyMoveStart();
        try {
            if (world.setBlock(pos, newState, 2)) {
                BlockEntity newTile;
                Block block = world.getBlockState(pos).getBlock();
                if (block == oldBlock.getBlock() && (newTile = world.getBlockEntity(pos)) instanceof TurtleBlockEntity) {
                    TurtleBlockEntity newTurtle = (TurtleBlockEntity)newTile;
                    newTurtle.setLevel(world);
                    newTurtle.transferStateFrom(oldOwner);
                    ServerComputer computer = newTurtle.createServerComputer();
                    computer.setPosition((ServerLevel)world, pos);
                    oldWorld.removeBlock(oldPos, false);
                    newTurtle.updateRedstone();
                    newTurtle.updateInputsImmediately();
                    boolean bl = true;
                    return bl;
                }
                world.removeBlock(pos, false);
            }
        }
        finally {
            oldOwner.notifyMoveEnd();
        }
        return false;
    }

    public Vec3 getVisualPosition(float f) {
        Vec3 offset = this.getRenderOffset(f);
        BlockPos pos = this.owner.getBlockPos();
        return new Vec3((double)pos.getX() + 0.5 + offset.x, (double)pos.getY() + 0.5 + offset.y, (double)pos.getZ() + 0.5 + offset.z);
    }

    public float getVisualYaw(float f) {
        float yaw = this.getDirection().toYRot();
        switch (this.animation) {
            case TURN_LEFT: {
                yaw += 90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw >= 360.0f)) break;
                yaw -= 360.0f;
                break;
            }
            case TURN_RIGHT: {
                yaw += -90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw < 0.0f)) break;
                yaw += 360.0f;
                break;
            }
        }
        return yaw;
    }

    @Override
    public Direction getDirection() {
        return this.owner.getDirection();
    }

    @Override
    public void setDirection(Direction dir) {
        this.owner.setDirection(dir);
    }

    @Override
    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void setSelectedSlot(int slot) {
        if (this.getLevel().isClientSide) {
            throw new UnsupportedOperationException("Cannot set the slot on the client");
        }
        if (slot >= 0 && slot < this.owner.getContainerSize()) {
            this.selectedSlot = slot;
            this.owner.onTileEntityChange();
        }
    }

    @Override
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isFuelNeeded() {
        return Config.turtlesNeedFuel;
    }

    @Override
    public int getFuelLevel() {
        return Math.min(this.fuelLevel, this.getFuelLimit());
    }

    @Override
    public void setFuelLevel(int level) {
        this.fuelLevel = Math.min(level, this.getFuelLimit());
        this.owner.onTileEntityChange();
    }

    @Override
    public int getFuelLimit() {
        return this.owner.getFuelLimit();
    }

    @Override
    public boolean consumeFuel(int fuel) {
        if (this.getLevel().isClientSide) {
            throw new UnsupportedOperationException("Cannot consume fuel on the client");
        }
        if (!this.isFuelNeeded()) {
            return true;
        }
        int consumption = Math.max(fuel, 0);
        if (this.getFuelLevel() >= consumption) {
            this.setFuelLevel(this.getFuelLevel() - consumption);
            return true;
        }
        return false;
    }

    @Override
    public void addFuel(int fuel) {
        if (this.getLevel().isClientSide) {
            throw new UnsupportedOperationException("Cannot add fuel on the client");
        }
        int addition = Math.max(fuel, 0);
        this.setFuelLevel(this.getFuelLevel() + addition);
    }

    @Override
    public MethodResult executeCommand(TurtleCommand command) {
        if (this.getLevel().isClientSide) {
            throw new UnsupportedOperationException("Cannot run commands on the client");
        }
        if (this.commandQueue.size() > 16) {
            return MethodResult.of(false, "Too many ongoing turtle commands");
        }
        this.commandQueue.offer(new TurtleCommandQueueEntry(++this.commandsIssued, command));
        int commandID = this.commandsIssued;
        return new CommandCallback((int)commandID).pull;
    }

    @Override
    public void playAnimation(TurtleAnimation animation) {
        if (this.getLevel().isClientSide) {
            throw new UnsupportedOperationException("Cannot play animations on the client");
        }
        this.animation = animation;
        if (this.animation == TurtleAnimation.SHORT_WAIT) {
            this.animationProgress = 4;
            this.lastAnimationProgress = 4;
        } else {
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
        BlockEntityHelpers.updateBlock(this.owner);
    }

    public @Nullable Holder<TurtleOverlay> getOverlay() {
        return this.overlay;
    }

    public void setOverlay(@Nullable Holder<TurtleOverlay> overlay) {
        if (!Objects.equals(this.overlay, overlay)) {
            this.overlay = overlay;
            BlockEntityHelpers.updateBlock(this.owner);
        }
    }

    @Override
    public void setColour(int colour) {
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (this.colourHex != colour) {
                this.colourHex = colour;
                BlockEntityHelpers.updateBlock(this.owner);
            }
        } else if (this.colourHex != -1) {
            this.colourHex = -1;
            BlockEntityHelpers.updateBlock(this.owner);
        }
    }

    @Override
    public int getColour() {
        return this.colourHex;
    }

    public void setOwningPlayer(GameProfile profile) {
        this.owningPlayer = profile;
    }

    @Override
    public @Nullable GameProfile getOwningPlayer() {
        return this.owningPlayer;
    }

    @Override
    public @Nullable ITurtleUpgrade getUpgrade(TurtleSide side) {
        Holder.Reference<ITurtleUpgrade> upgrade = this.upgrades[side.ordinal()].upgrade;
        return upgrade == null ? null : (ITurtleUpgrade)upgrade.value();
    }

    @Override
    public @Nullable UpgradeData<ITurtleUpgrade> getUpgradeWithData(TurtleSide side) {
        return this.upgrades[side.ordinal()].getUpgrade();
    }

    @Override
    public void setUpgrade(TurtleSide side, @Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        if (!this.setUpgradeDirect(side, upgrade) || this.owner.getLevel() == null) {
            return;
        }
        BlockEntityHelpers.updateBlock(this.owner);
        this.owner.updateInputsImmediately();
    }

    private boolean setUpgradeDirect(TurtleSide side, @Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        UpgradeInstance instance = this.upgrades[side.ordinal()];
        if (instance.upgrade == null && upgrade == null) {
            return false;
        }
        instance.setUpgrade(upgrade);
        if (this.owner.getLevel() != null && !this.owner.getLevel().isClientSide) {
            this.updatePeripherals(this.owner.createServerComputer());
        }
        return true;
    }

    @Override
    public @Nullable IPeripheral getPeripheral(TurtleSide side) {
        return this.upgrades[side.ordinal()].peripheral;
    }

    @Override
    public DataComponentPatch getUpgradeData(TurtleSide side) {
        return this.upgrades[side.ordinal()].data;
    }

    @Override
    public void setUpgradeData(TurtleSide side, DataComponentPatch data) {
        UpgradeInstance upgrade = this.upgrades[side.ordinal()];
        if (Objects.equals(upgrade.data, data)) {
            return;
        }
        upgrade.data = data;
        upgrade.cachedUpgradeData = null;
        BlockEntityHelpers.updateBlock(this.owner);
    }

    public Vec3 getRenderOffset(float f) {
        switch (this.animation) {
            case MOVE_FORWARD: 
            case MOVE_BACK: 
            case MOVE_UP: 
            case MOVE_DOWN: {
                Direction dir = switch (this.animation) {
                    case TurtleAnimation.MOVE_FORWARD -> this.getDirection();
                    case TurtleAnimation.MOVE_BACK -> this.getDirection().getOpposite();
                    case TurtleAnimation.MOVE_UP -> Direction.UP;
                    case TurtleAnimation.MOVE_DOWN -> Direction.DOWN;
                    default -> throw new IllegalStateException("Impossible direction");
                };
                double distance = -1.0 + (double)this.getAnimationFraction(f);
                return new Vec3(distance * (double)dir.getStepX(), distance * (double)dir.getStepY(), distance * (double)dir.getStepZ());
            }
        }
        return Vec3.ZERO;
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return side == TurtleSide.LEFT && this.animation == TurtleAnimation.SWING_LEFT_TOOL || side == TurtleSide.RIGHT && this.animation == TurtleAnimation.SWING_RIGHT_TOOL ? 45.0f * (float)Math.sin((double)this.getAnimationFraction(f) * Math.PI) : 0.0f;
    }

    private static ComputerSide toDirection(TurtleSide side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case TurtleSide.LEFT -> ComputerSide.LEFT;
            case TurtleSide.RIGHT -> ComputerSide.RIGHT;
        };
    }

    private void updatePeripherals(ServerComputer serverComputer) {
        if (serverComputer == null) {
            return;
        }
        for (TurtleSide side : TurtleSide.values()) {
            ITurtleUpgrade upgrade = this.getUpgrade(side);
            IPeripheral peripheral = null;
            if (upgrade != null && upgrade.getUpgradeType().isPeripheral()) {
                peripheral = upgrade.createPeripheral(this, side);
            }
            UpgradeInstance instance = this.upgrades[side.ordinal()];
            if (PeripheralHelpers.equals(instance.peripheral, peripheral)) {
                peripheral = instance.peripheral;
            } else {
                instance.peripheral = peripheral;
            }
            serverComputer.setPeripheral(TurtleBrain.toDirection(side), peripheral);
        }
    }

    private void updateCommands() {
        if (this.animation != TurtleAnimation.NONE || this.commandQueue.isEmpty()) {
            return;
        }
        ServerComputer computer = this.owner.getServerComputer();
        if (computer != null && !computer.getMainThreadMonitor().canWork()) {
            return;
        }
        TurtleCommandQueueEntry nextCommand = this.commandQueue.poll();
        if (nextCommand == null) {
            return;
        }
        long start = System.nanoTime();
        TurtleCommandResult result = nextCommand.command().execute(this);
        long end = System.nanoTime();
        if (computer == null) {
            return;
        }
        computer.getMainThreadMonitor().trackWork(end - start, TimeUnit.NANOSECONDS);
        int callbackID = nextCommand.callbackID();
        if (callbackID < 0) {
            return;
        }
        if (result != null && result.isSuccess()) {
            Object[] results = result.getResults();
            if (results != null) {
                Object[] arguments = new Object[results.length + 2];
                arguments[0] = callbackID;
                arguments[1] = true;
                System.arraycopy(results, 0, arguments, 2, results.length);
                computer.queueEvent("turtle_response", arguments);
            } else {
                computer.queueEvent("turtle_response", new Object[]{callbackID, true});
            }
        } else {
            computer.queueEvent("turtle_response", new Object[]{callbackID, false, result != null ? result.getErrorMessage() : null});
        }
    }

    private void updateAnimation() {
        if (this.animation != TurtleAnimation.NONE) {
            Vec3 position;
            Holiday currentHoliday;
            Level world = this.getLevel();
            if (Config.turtlesCanPush && (this.animation == TurtleAnimation.MOVE_FORWARD || this.animation == TurtleAnimation.MOVE_BACK || this.animation == TurtleAnimation.MOVE_UP || this.animation == TurtleAnimation.MOVE_DOWN)) {
                BlockPos pos = this.getPosition();
                Direction moveDir = switch (this.animation) {
                    case TurtleAnimation.MOVE_FORWARD -> this.getDirection();
                    case TurtleAnimation.MOVE_BACK -> this.getDirection().getOpposite();
                    case TurtleAnimation.MOVE_UP -> Direction.UP;
                    case TurtleAnimation.MOVE_DOWN -> Direction.DOWN;
                    default -> throw new IllegalStateException("Impossible direction");
                };
                double minX = pos.getX();
                double minY = pos.getY();
                double minZ = pos.getZ();
                double maxX = minX + 1.0;
                double maxY = minY + 1.0;
                double maxZ = minZ + 1.0;
                float pushFrac = 1.0f - (float)(this.animationProgress + 1) / 8.0f;
                float push = Math.max(pushFrac + 0.0125f, 0.0f);
                if (moveDir.getStepX() < 0) {
                    minX += (double)((float)moveDir.getStepX() * push);
                } else {
                    maxX -= (double)((float)moveDir.getStepX() * push);
                }
                if (moveDir.getStepY() < 0) {
                    minY += (double)((float)moveDir.getStepY() * push);
                } else {
                    maxY -= (double)((float)moveDir.getStepY() * push);
                }
                if (moveDir.getStepZ() < 0) {
                    minZ += (double)((float)moveDir.getStepZ() * push);
                } else {
                    maxZ -= (double)((float)moveDir.getStepZ() * push);
                }
                AABB aabb = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
                List list = world.getEntities((Entity)null, aabb, TurtleBrain::canPush);
                if (!list.isEmpty()) {
                    double pushStep = 0.125;
                    double pushStepX = (double)moveDir.getStepX() * pushStep;
                    double pushStepY = (double)moveDir.getStepY() * pushStep;
                    double pushStepZ = (double)moveDir.getStepZ() * pushStep;
                    for (Entity entity : list) {
                        entity.move(MoverType.PISTON, new Vec3(pushStepX, pushStepY, pushStepZ));
                    }
                }
            }
            if (world.isClientSide && this.animation == TurtleAnimation.MOVE_FORWARD && this.animationProgress == 4 && (currentHoliday = Holiday.getCurrent()) == Holiday.VALENTINES && (position = this.getVisualPosition(1.0f)) != null) {
                double x = position.x + world.random.nextGaussian() * 0.1;
                double y = position.y + 0.5 + world.random.nextGaussian() * 0.1;
                double z = position.z + world.random.nextGaussian() * 0.1;
                world.addParticle((ParticleOptions)ParticleTypes.HEART, x, y, z, world.random.nextGaussian() * 0.02, world.random.nextGaussian() * 0.02, world.random.nextGaussian() * 0.02);
            }
            this.lastAnimationProgress = this.animationProgress++;
            if (this.animationProgress >= 8) {
                this.animation = TurtleAnimation.NONE;
                this.animationProgress = 0;
                this.lastAnimationProgress = 0;
            }
        }
    }

    private static boolean canPush(Entity entity) {
        return !entity.isSpectator() && entity.getPistonPushReaction() != PushReaction.IGNORE;
    }

    private float getAnimationFraction(float f) {
        float next = (float)this.animationProgress / 8.0f;
        float previous = (float)this.lastAnimationProgress / 8.0f;
        return previous + (next - previous) * f;
    }

    @Override
    public ItemStack getItemSnapshot(int slot) {
        return this.owner.getItemSnapshot(slot);
    }

    private static final class UpgradeInstance {
        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Holder.Reference<ITurtleUpgrade> upgrade;
        private DataComponentPatch data = DataComponentPatch.EMPTY;
        private @Nullable IPeripheral peripheral;
        private @Nullable UpgradeData<ITurtleUpgrade> cachedUpgradeData;

        private UpgradeInstance() {
        }

        public void setUpgrade(@Nullable UpgradeData<ITurtleUpgrade> upgrade) {
            if (upgrade == null) {
                this.upgrade = null;
                this.data = DataComponentPatch.EMPTY;
                this.cachedUpgradeData = null;
            } else {
                this.upgrade = upgrade.holder();
                this.data = upgrade.data();
                this.cachedUpgradeData = upgrade;
            }
        }

        public @Nullable UpgradeData<ITurtleUpgrade> getUpgrade() {
            if (this.upgrade == null) {
                return null;
            }
            UpgradeData<ITurtleUpgrade> cached = this.cachedUpgradeData;
            if (cached != null) {
                return cached;
            }
            this.cachedUpgradeData = UpgradeData.of(this.upgrade, this.data);
            return this.cachedUpgradeData;
        }
    }

    private static final class CommandCallback
    implements ILuaCallback {
        final MethodResult pull = MethodResult.pullEvent("turtle_response", this);
        private final int command;

        CommandCallback(int command) {
            this.command = command;
        }

        @Override
        public MethodResult resume(Object[] response) {
            Number id;
            block5: {
                block4: {
                    Object object;
                    if (response.length < 3 || !((object = response[1]) instanceof Number)) break block4;
                    id = (Number)object;
                    if (response[2] instanceof Boolean) break block5;
                }
                return this.pull;
            }
            if (id.intValue() != this.command) {
                return this.pull;
            }
            return MethodResult.of(Arrays.copyOfRange(response, 2, response.length));
        }
    }
}

