/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.generic.ComponentLookup;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jspecify.annotations.Nullable;

public final class GenericPeripheralProvider {
    private final List<ComponentLookup> lookups = new ArrayList<ComponentLookup>();

    public synchronized void registerLookup(ComponentLookup lookup) {
        Objects.requireNonNull(lookup);
        if (!this.lookups.contains(lookup)) {
            this.lookups.add(lookup);
        }
    }

    public void forEachMethod(MethodSupplier<PeripheralMethod> methods, ServerLevel level, BlockPos pos, Direction side, BlockEntity blockEntity, MethodSupplier.TargetedConsumer<PeripheralMethod> consumer) {
        methods.forEachMethod(blockEntity, consumer);
        for (ComponentLookup lookup : this.lookups) {
            Object contents = lookup.find(level, pos, blockEntity.getBlockState(), blockEntity, side);
            if (contents == null) continue;
            methods.forEachMethod(contents, consumer);
        }
    }

    public @Nullable IPeripheral getPeripheral(ServerLevel level, BlockPos pos, Direction side, @Nullable BlockEntity blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        GenericPeripheralBuilder builder = new GenericPeripheralBuilder();
        this.forEachMethod(ServerContext.get(level.getServer()).peripheralMethods(), level, pos, side, blockEntity, builder::addMethod);
        return builder.toPeripheral(blockEntity, side);
    }
}

