/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model.turtle;

import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.Holiday;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class TurtleModelParts<T> {
    private static final Transformation identity;
    private static final Transformation flip;
    private final BakedModel familyModel;
    private final BakedModel colourModel;
    private final Function<TransformedModel, BakedModel> transformer;
    private final Function<Combination, T> buildModel;
    private final Map<TransformedModel, BakedModel> transformCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(30L, TimeUnit.SECONDS).build().asMap();
    private final Map<Combination, T> modelCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(30L, TimeUnit.SECONDS).build().asMap();

    public TurtleModelParts(BakedModel familyModel, BakedModel colourModel, ModelTransformer transformer, Function<List<BakedModel>, T> combineModel) {
        this.familyModel = familyModel;
        this.colourModel = colourModel;
        this.transformer = x -> transformer.transform(x.model(), x.matrix());
        this.buildModel = x -> combineModel.apply(this.buildModel((Combination)x));
    }

    public T getModel(ItemStack stack) {
        Combination combination = this.getCombination(stack);
        return this.modelCache.computeIfAbsent(combination, this.buildModel);
    }

    private Combination getCombination(ItemStack stack) {
        boolean christmas = Holiday.getCurrent() == Holiday.CHRISTMAS;
        UpgradeData<ITurtleUpgrade> leftUpgrade = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
        UpgradeData<ITurtleUpgrade> rightUpgrade = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
        TurtleOverlay overlay = TurtleItem.getOverlay(stack);
        String label = DataComponentUtil.getCustomName((DataComponentHolder)stack);
        boolean flip = label != null && (label.equals("Dinnerbone") || label.equals("Grumm"));
        return new Combination(stack.has(DataComponents.DYED_COLOR), leftUpgrade, rightUpgrade, overlay, christmas, flip);
    }

    private List<BakedModel> buildModel(Combination combo) {
        boolean showChristmas;
        Minecraft mc = Minecraft.getInstance();
        ModelManager modelManager = mc.getItemRenderer().getItemModelShaper().getModelManager();
        Transformation transformation = combo.flip ? flip : identity;
        ArrayList<BakedModel> parts = new ArrayList<BakedModel>(4);
        parts.add(this.transform(combo.colour() ? this.colourModel : this.familyModel, transformation));
        if (combo.overlay() != null) {
            this.addPart(parts, modelManager, transformation, combo.overlay().model());
        }
        if (showChristmas = TurtleOverlay.showElfOverlay(combo.overlay(), combo.christmas())) {
            this.addPart(parts, modelManager, transformation, TurtleOverlay.ELF_MODEL);
        }
        this.addUpgrade(parts, transformation, TurtleSide.LEFT, combo.leftUpgrade());
        this.addUpgrade(parts, transformation, TurtleSide.RIGHT, combo.rightUpgrade());
        return parts;
    }

    private void addPart(List<BakedModel> parts, ModelManager modelManager, Transformation transformation, ResourceLocation model) {
        parts.add(this.transform(ClientPlatformHelper.get().getModel(modelManager, model), transformation));
    }

    private void addUpgrade(List<BakedModel> parts, Transformation transformation, TurtleSide side, @Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        if (upgrade == null) {
            return;
        }
        TransformedModel model = TurtleUpgradeModellers.getModel(upgrade.upgrade(), upgrade.data(), side);
        parts.add(this.transform(model.model(), transformation.compose(model.matrix())));
    }

    private BakedModel transform(BakedModel model, Transformation transformation) {
        if (transformation.equals((Object)Transformation.identity())) {
            return model;
        }
        return this.transformCache.computeIfAbsent(new TransformedModel(model, transformation), this.transformer);
    }

    static {
        PoseStack stack = new PoseStack();
        stack.translate(0.5f, 0.5f, 0.5f);
        stack.scale(1.0f, -1.0f, 1.0f);
        stack.translate(-0.5f, -0.5f, -0.5f);
        identity = Transformation.identity();
        flip = new Transformation(stack.last().pose());
    }

    public static interface ModelTransformer {
        public BakedModel transform(BakedModel var1, Transformation var2);
    }

    private record Combination(boolean colour, @Nullable UpgradeData<ITurtleUpgrade> leftUpgrade, @Nullable UpgradeData<ITurtleUpgrade> rightUpgrade, @Nullable TurtleOverlay overlay, boolean christmas, boolean flip) {
    }
}

