/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.gui.AbstractComputerScreen;
import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.TerminalWidget;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.SpriteRenderer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class TurtleScreen
extends AbstractComputerScreen<TurtleMenu> {
    private static final ResourceLocation BACKGROUND_NORMAL = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"textures/gui/turtle_normal.png");
    private static final ResourceLocation BACKGROUND_ADVANCED = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"textures/gui/turtle_advanced.png");
    private static final ResourceLocation SELECTED_NORMAL = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"turtle_normal_selected_slot");
    private static final ResourceLocation SELECTED_ADVANCED = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"turtle_advanced_selected_slot");
    private static final int TEX_WIDTH = 278;
    private static final int TEX_HEIGHT = 217;
    private static final int FULL_TEX_SIZE = 512;

    public TurtleScreen(TurtleMenu container, Inventory player, Component title) {
        super(container, player, title, 8);
        this.imageWidth = 295;
        this.imageHeight = 217;
    }

    @Override
    protected TerminalWidget createTerminal() {
        return new TerminalWidget(this.terminalData, this.input, this.leftPos + 8 + 17, this.topPos + 8);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        boolean advanced = this.family == ComputerFamily.ADVANCED;
        ResourceLocation texture = advanced ? BACKGROUND_ADVANCED : BACKGROUND_NORMAL;
        graphics.blit(texture, this.leftPos + 17, this.topPos, 0, 0.0f, 0.0f, 278, 217, 512, 512);
        int slot = ((TurtleMenu)this.getMenu()).getSelectedSlot();
        if (slot >= 0) {
            int slotX = slot % 4;
            int slotY = slot / 4;
            graphics.blitSprite(advanced ? SELECTED_ADVANCED : SELECTED_NORMAL, this.leftPos + 192 - 2 + slotX * 18, this.topPos + 134 - 2 + slotY * 18, 0, 22, 22);
        }
        SpriteRenderer spriteRenderer = SpriteRenderer.createForGui(graphics, RenderTypes.GUI_SPRITES);
        ComputerSidebar.renderBackground(spriteRenderer, GuiSprites.getComputerTextures(this.family), this.leftPos, this.topPos + this.sidebarYOffset);
        graphics.flush();
    }
}

