/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.particle;

import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class CylinderParticleManager {
    private static final Random RANDOM = new Random();

    public static void spawnParticles(Level level, LivingEntity entity, int particleCount, ParticleOptions particleType, ParticleDirection direction, double radius, double height, double yOffset) {
        if (!level.isClientSide) {
            double baseY = entity.getY() + yOffset;
            for (int i = 0; i < particleCount; ++i) {
                double theta = Math.PI * 2 * RANDOM.nextDouble();
                double yPosition = baseY + RANDOM.nextDouble() * height;
                double xOffset = radius * Math.cos(theta);
                double zOffset = radius * Math.sin(theta);
                Vec3 directionVector = direction == ParticleDirection.UPWARD ? new Vec3(0.0, 1.0, 0.0).normalize() : (direction == ParticleDirection.DOWNWARD ? new Vec3(0.0, -1.0, 0.0).normalize() : (direction == ParticleDirection.INWARD ? new Vec3(-xOffset, 0.0, -zOffset).normalize() : new Vec3(xOffset, 0.0, zOffset).normalize()));
                MagicManager.spawnParticles((Level)level, (ParticleOptions)particleType, (double)(entity.getX() + xOffset), (double)yPosition, (double)(entity.getZ() + zOffset), (int)0, (double)directionVector.x, (double)directionVector.y, (double)directionVector.z, (double)0.1, (boolean)true);
            }
        }
    }
}

