/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.item;

import com.blakebr0.cucumber.item.tool.BasePaxelItem;
import com.blakebr0.mysticalagradditions.config.ModFeatureFlags;
import com.blakebr0.mysticalagradditions.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureDataComponentTypes;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EssencePaxelItem
extends BasePaxelItem
implements ITinkerable {
    private static final EnumSet<AugmentType> TYPES = EnumSet.of(AugmentType.TOOL, AugmentType.PICKAXE, AugmentType.SHOVEL, AugmentType.AXE);
    private final int tinkerableTier;
    private final int slots;

    public EssencePaxelItem(Tier tier, int tinkerableTier, int slots) {
        super(tier, p -> {
            p.component((Supplier)MysticalAgricultureDataComponentTypes.EQUIPPED_AUGMENTS, new ArrayList());
            if (tier.getUses() == 0) {
                p.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
            }
            return p;
        });
        this.tinkerableTier = tinkerableTier;
        this.slots = slots;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onItemUse(context)) continue;
            success = true;
        }
        if (success) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onRightClick(stack, world, player, hand)) continue;
            success = true;
        }
        if (success) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onRightClickEntity(stack, player, target, hand)) continue;
            success = true;
        }
        return success ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onHitEntity(stack, target, attacker)) continue;
            success = true;
        }
        return success;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        super.mineBlock(stack, world, state, pos, entity);
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onBlockDestroyed(stack, world, state, pos, entity)) continue;
            success = true;
        }
        return success;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        for (Augment augment : AugmentUtils.getAugments((ItemStack)stack)) {
            augment.onInventoryTick(stack, level, entity, slot, isSelected);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(ModTooltips.getTooltipForTier(this.tinkerableTier));
        for (Augment augment : AugmentUtils.getAugments((ItemStack)stack)) {
            tooltip.add((Component)augment.getDisplayName());
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        return ModFeatureFlags.ENCHANTABLE_SUPREMIUM_TOOLS.isEnabled() || super.isEnchantable(stack);
    }

    public int getAugmentSlots() {
        return this.slots;
    }

    public EnumSet<AugmentType> getAugmentTypes() {
        return TYPES;
    }

    public int getTinkerableTier() {
        return this.tinkerableTier;
    }
}

