/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.crafting.processoverride;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.core.crafting.processoverride.CraftingProcessOverrideCraftingTable;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingProcessOverrideSmithingTable
implements ICraftingProcessOverride {
    @Override
    public boolean isApplicable(PartPos target) {
        return target.getPos().getLevel(true).getBlockState(target.getPos().getBlockPos()).getBlock() instanceof SmithingTableBlock;
    }

    @Override
    public boolean craft(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, IRecipeDefinition recipe, ICraftingResultsSink resultsSink, boolean simulate) {
        PartPos target = targetGetter.apply(IngredientComponent.ITEMSTACK);
        List itemStacks = ingredients.getInstances(IngredientComponent.ITEMSTACK);
        if (itemStacks == null || itemStacks.size() != 3) {
            throw new IllegalArgumentException("Can only smith in a grid with 3 items, while got" + String.valueOf(itemStacks == null ? "null" : Integer.valueOf(itemStacks.size())));
        }
        SmithingRecipeInput smithingRecipeInput = new SmithingRecipeInput((ItemStack)itemStacks.get(0), (ItemStack)itemStacks.get(1), (ItemStack)itemStacks.get(2));
        Level level = target.getPos().getLevel(true);
        return IModHelpers.get().getCraftingHelpers().findServerRecipe(RecipeType.SMITHING, (RecipeInput)smithingRecipeInput, level).map(recipeHolder -> {
            SmithingRecipe smithingRecipe = (SmithingRecipe)recipeHolder.value();
            ItemStack result = smithingRecipe.assemble((RecipeInput)smithingRecipeInput, (HolderLookup.Provider)level.registryAccess());
            if (result.isEmpty()) {
                return false;
            }
            if (!simulate) {
                FakePlayer player = CraftingProcessOverrideCraftingTable.getFakePlayer((ServerLevel)target.getPos().getLevel(true));
                result.onCraftedBy(target.getPos().getLevel(true), (Player)player, 1);
                resultsSink.addResult(IngredientComponent.ITEMSTACK, result);
                for (ItemStack remainingItem : smithingRecipe.getRemainingItems((RecipeInput)smithingRecipeInput)) {
                    if (remainingItem.isEmpty()) continue;
                    resultsSink.addResult(IngredientComponent.ITEMSTACK, remainingItem);
                }
            }
            return true;
        }).orElse(false);
    }
}

