/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay;

import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4d;
import org.joml.Vector4d;

public class LightOverlayRenderer
implements ILightRenderer {
    private static final ResourceLocation BLANK_TEX = ResourceLocation.fromNamespaceAndPath((String)"moreoverlays", (String)"textures/blank.png");
    private static Tesselator tess;
    private static BufferBuilder renderer;
    private static Minecraft minecraft;

    public LightOverlayRenderer() {
        tess = Tesselator.getInstance();
        renderer = tess.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        minecraft = Minecraft.getInstance();
    }

    private static void renderCross(PoseStack matrixstack, BlockPos pos, float r, float g, float b) {
        LocalPlayer player = LightOverlayRenderer.minecraft.player;
        if (player == null) {
            return;
        }
        BlockState blockStateBelow = player.level().getBlockState(pos);
        float y = 0.0f;
        y = blockStateBelow.is(BlockTags.SNOW) ? ((double)pos.getY() > player.getY() ? 0.005f + ((float)pos.getY() + 0.125f) : (float)((double)(0.005f + ((float)pos.getY() + 0.125f)) + (double)0.01f * -((double)pos.getY() - player.getY() - 1.0))) : ((double)pos.getY() > player.getY() ? 0.005f + (float)pos.getY() : (float)((double)(0.005f + (float)pos.getY()) + (double)0.01f * -((double)pos.getY() - player.getY() - 1.0)));
        int x0 = pos.getX();
        int x1 = x0 + 1;
        int z0 = pos.getZ();
        int z1 = z0 + 1;
        Matrix4d matrix4d = new Matrix4d();
        matrixstack.last().pose().get(matrix4d);
        Camera camera = LightOverlayRenderer.minecraft.gameRenderer.getMainCamera();
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        LightOverlayRenderer.drawVertex(matrix4d, (double)x0 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
        LightOverlayRenderer.drawVertex(matrix4d, (double)x1 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
        LightOverlayRenderer.drawVertex(matrix4d, (double)x1 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
        LightOverlayRenderer.drawVertex(matrix4d, (double)x0 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
    }

    private static void drawVertex(Matrix4d matrix, double x, double y, double z, float r, float g, float b) {
        Vector4d vector4d = matrix.transform(new Vector4d(x, y, z, 1.0));
        renderer.addVertex((float)vector4d.x(), (float)vector4d.y(), (float)vector4d.z()).setColor(r, g, b, 1.0f);
    }

    @Override
    public void renderOverlays(ILightScanner scanner, PoseStack matrixstack) {
        Minecraft.getInstance().getTextureManager().bindForSetup(BLANK_TEX);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)((Double)Config.render_chunkLineWidth.get()).floatValue());
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (Minecraft.getInstance().options.graphicsMode().get() != GraphicsStatus.FABULOUS) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableCull();
        }
        float ar = (float)((Integer)Config.render_spawnAColor.get() >> 16 & 0xFF) / 255.0f;
        float ag = (float)((Integer)Config.render_spawnAColor.get() >> 8 & 0xFF) / 255.0f;
        float ab = (float)((Integer)Config.render_spawnAColor.get() & 0xFF) / 255.0f;
        float nr = (float)((Integer)Config.render_spawnNColor.get() >> 16 & 0xFF) / 255.0f;
        float ng = (float)((Integer)Config.render_spawnNColor.get() >> 8 & 0xFF) / 255.0f;
        float nb = (float)((Integer)Config.render_spawnNColor.get() & 0xFF) / 255.0f;
        renderer = tess.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        for (Pair<BlockPos, Byte> entry : scanner.getLightModes()) {
            Byte mode = (Byte)entry.getValue();
            if (mode == null || mode == 0) continue;
            if (mode == 1) {
                LightOverlayRenderer.renderCross(matrixstack, (BlockPos)entry.getKey(), nr, ng, nb);
                continue;
            }
            if (mode != 2) continue;
            LightOverlayRenderer.renderCross(matrixstack, (BlockPos)entry.getKey(), ar, ag, ab);
        }
        MeshData meshData = renderer.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        RenderSystem.depthMask((boolean)true);
        if (Minecraft.getInstance().options.graphicsMode().get() != GraphicsStatus.FABULOUS) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableBlend();
        }
    }
}

