/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay;

import at.ridgo8.moreoverlays.MoreOverlays;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.api.lightoverlay.LightOverlayReloadHandlerEvent;
import at.ridgo8.moreoverlays.config.Config;
import at.ridgo8.moreoverlays.lightoverlay.LightOverlayRenderer;
import at.ridgo8.moreoverlays.lightoverlay.LightScannerVanilla;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class LightOverlayHandler {
    private static boolean enabled = false;
    public static ILightRenderer renderer = null;
    public static ILightScanner scanner = null;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new LightOverlayHandler());
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        if (LightOverlayHandler.enabled == enabled) {
            return;
        }
        if (enabled) {
            LightOverlayHandler.reloadHandlerInternal();
            Minecraft.getInstance().player.displayClientMessage(Component.nullToEmpty((String)(String.valueOf(ChatFormatting.YELLOW) + "Light Overlay Enabled")), true);
        } else {
            scanner.clear();
            Minecraft.getInstance().player.displayClientMessage(Component.nullToEmpty((String)(String.valueOf(ChatFormatting.YELLOW) + "Light Overlay Disabled")), true);
        }
        LightOverlayHandler.enabled = enabled;
    }

    public static void reloadHandler() {
        if (enabled) {
            MoreOverlays.logger.info("Light overlay handlers reloaded");
            LightOverlayHandler.reloadHandlerInternal();
        }
    }

    private static void reloadHandlerInternal() {
        LightOverlayReloadHandlerEvent event = new LightOverlayReloadHandlerEvent((Boolean)Config.light_IgnoreSpawnList.get(), LightOverlayRenderer.class, LightScannerVanilla.class);
        NeoForge.EVENT_BUS.post((Event)event);
        if (renderer == null || renderer.getClass() != event.getRenderer()) {
            try {
                renderer = event.getRenderer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                MoreOverlays.logger.warn((Message)new FormattedMessage("Could not create ILightRenderer from type \"%s\"!", (Object)event.getRenderer().getName()), (Throwable)e);
                renderer = new LightOverlayRenderer();
            }
        }
        if (scanner == null || scanner.getClass() != event.getScanner()) {
            if (scanner != null && enabled) {
                scanner.clear();
            }
            try {
                scanner = event.getScanner().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                MoreOverlays.logger.warn((Message)new FormattedMessage("Could not create ILightScanner from type \"%s\"!", (Object)event.getScanner().getName()), (Throwable)e);
                scanner = new LightScannerVanilla();
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        LightOverlayHandler.setEnabled(false);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderLevelStageEvent event) {
        if (!event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            return;
        }
        if (enabled) {
            renderer.renderOverlays(scanner, event.getPoseStack());
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().player != null && enabled && (Minecraft.getInstance().screen == null || !Minecraft.getInstance().screen.isPauseScreen())) {
            scanner.update((Player)Minecraft.getInstance().player);
        }
    }
}

