/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.itemsearch;

import at.ridgo8.moreoverlays.api.itemsearch.SlotHandler;
import at.ridgo8.moreoverlays.api.itemsearch.SlotViewWrapper;
import at.ridgo8.moreoverlays.config.Config;
import at.ridgo8.moreoverlays.itemsearch.GuiUtils;
import at.ridgo8.moreoverlays.itemsearch.ItemUtils;
import at.ridgo8.moreoverlays.itemsearch.JeiModule;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class GuiRenderer {
    public static final GuiRenderer INSTANCE = new GuiRenderer();
    private static final float OVERLAY_ZLEVEL = 299.0f;
    private static final float FRAME_RADIUS = 1.0f;
    private static boolean enabled = false;
    private static String lastFilterText = "";
    private static boolean emptyFilter = true;
    private static BiMap<Slot, SlotViewWrapper> views = HashBiMap.create();
    private boolean allowRender = false;
    private int guiOffsetX = 0;
    private int guiOffsetY = 0;

    public void guiInit(Screen gui) {
        if (!this.canShowIn(gui)) {
            return;
        }
        this.guiOffsetX = GuiUtils.getGuiLeft((AbstractContainerScreen)gui);
        this.guiOffsetY = GuiUtils.getGuiTop((AbstractContainerScreen)gui);
    }

    public void guiOpen(Screen gui) {
    }

    public void preDraw(PoseStack matrixstack) {
        Screen guiscr = Minecraft.getInstance().screen;
        EditBox textField = JeiModule.getJEITextField();
        if (this.canShowIn(guiscr)) {
            this.allowRender = true;
            if (textField != null && enabled) {
                this.drawSearchFrame(textField, matrixstack);
            }
        }
    }

    public void postDraw() {
        Screen guiscr = Minecraft.getInstance().screen;
        if (this.allowRender && this.canShowIn(guiscr)) {
            this.allowRender = false;
            this.drawSlotOverlay((AbstractContainerScreen)guiscr);
        }
    }

    private void drawSearchFrame(EditBox textField, PoseStack matrixstack) {
        Matrix4f matrix4f = matrixstack.last().pose();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tess = Tesselator.getInstance();
        float x = textField.getX() - 2;
        float y = textField.getY() - 4;
        float width = textField.getWidth() + 8;
        float height = textField.getHeight() - 4;
        float r = (float)((Integer)Config.search_searchBoxColor.get() >> 16 & 0xFF) / 255.0f;
        float g = (float)((Integer)Config.search_searchBoxColor.get() >> 8 & 0xFF) / 255.0f;
        float b = (float)((Integer)Config.search_searchBoxColor.get() & 0xFF) / 255.0f;
        BufferBuilder renderer = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        renderer.addVertex(matrix4f, x + width + 1.0f, y - 1.0f, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x - 1.0f, y - 1.0f, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x - 1.0f, y, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x + width + 1.0f, y, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x, y, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x - 1.0f, y, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x - 1.0f, y + height, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x, y + height, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x + width + 1.0f, y + height, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x - 1.0f, y + height, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x - 1.0f, y + height + 1.0f, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x + width + 1.0f, y + height + 1.0f, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x + width + 1.0f, y, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x + width, y, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x + width, y + height, 1000.0f).setColor(r, g, b, 1.0f);
        renderer.addVertex(matrix4f, x + width + 1.0f, y + height, 1000.0f).setColor(r, g, b, 1.0f);
        MeshData meshData = renderer.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    public void renderTooltip(ItemStack stack) {
        Screen guiscr = Minecraft.getInstance().screen;
        if (this.allowRender && this.canShowIn(guiscr)) {
            this.allowRender = false;
            this.drawSlotOverlay((AbstractContainerScreen)guiscr);
        }
    }

    private void drawSlotOverlay(AbstractContainerScreen<?> gui) {
        Lighting.setupForFlatItems();
        if (!enabled || views == null || views.isEmpty()) {
            return;
        }
        Tesselator tess = Tesselator.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder renderer = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float r = (float)((Integer)Config.search_filteredSlotColor.get() >> 16 & 0xFF) / 255.0f;
        float g = (float)((Integer)Config.search_filteredSlotColor.get() >> 8 & 0xFF) / 255.0f;
        float b = (float)((Integer)Config.search_filteredSlotColor.get() & 0xFF) / 255.0f;
        float a = ((Double)Config.search_filteredSlotTransparancy.get()).floatValue();
        for (Map.Entry slot : views.entrySet()) {
            if (!((SlotViewWrapper)slot.getValue()).isEnableOverlay()) continue;
            Vec2 posvec = ((SlotViewWrapper)slot.getValue()).getView().getRenderPos(this.guiOffsetX, this.guiOffsetY);
            float px = posvec.x;
            float py = posvec.y;
            renderer.addVertex(px + 16.0f + (float)this.guiOffsetX, py + (float)this.guiOffsetY, 299.0f).setColor(r, g, b, a);
            renderer.addVertex(px + (float)this.guiOffsetX, py + (float)this.guiOffsetY, 299.0f).setColor(r, g, b, a);
            renderer.addVertex(px + (float)this.guiOffsetX, py + 16.0f + (float)this.guiOffsetY, 299.0f).setColor(r, g, b, a);
            renderer.addVertex(px + 16.0f + (float)this.guiOffsetX, py + 16.0f + (float)this.guiOffsetY, 299.0f).setColor(r, g, b, a);
        }
        MeshData meshData = renderer.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        RenderSystem.disableBlend();
    }

    public boolean canShowIn(Screen gui) {
        return gui instanceof AbstractContainerScreen && ((AbstractContainerScreen)gui).getMenu() != null && !((AbstractContainerScreen)gui).getMenu().slots.isEmpty();
    }

    private void checkSlots(AbstractContainerScreen<?> container) {
        if (views == null) {
            views = HashBiMap.create();
        } else {
            views.clear();
        }
        List filteredIngredients = JeiModule.filter.getFilteredIngredients((IIngredientType)VanillaTypes.ITEM_STACK);
        if (filteredIngredients.size() > (Integer)Config.search_maxResults.get()) {
            return;
        }
        for (Slot slot : container.getMenu().slots) {
            SlotViewWrapper wrapper;
            if (!views.containsKey((Object)slot)) {
                wrapper = new SlotViewWrapper(SlotHandler.INSTANCE.getViewSlot(container, slot));
                views.put((Object)slot, (Object)wrapper);
            } else {
                wrapper = (SlotViewWrapper)views.get((Object)slot);
            }
            wrapper.setEnableOverlay(wrapper.getView().canSearch() && !this.isSearchedItem(slot.getItem(), filteredIngredients));
        }
    }

    private boolean isSearchedItem(ItemStack stack, List<ItemStack> filteredIngredients) {
        if (emptyFilter) {
            return true;
        }
        if (stack.isEmpty()) {
            return false;
        }
        for (ItemStack ingredient : filteredIngredients) {
            if (!ItemUtils.ingredientMatches(ingredient, stack)) continue;
            return true;
        }
        return this.matchesTooltipAndDisplayName(stack);
    }

    private boolean matchesTooltipAndDisplayName(ItemStack stack) {
        String searchString = JeiModule.getJEITextField().getValue().toLowerCase(Locale.ROOT);
        String[] searchWords = searchString.split(" ");
        return stack.getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), (Player)Minecraft.getInstance().player, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().anyMatch(tip -> {
            String tipLower = tip.getString().toLowerCase(Locale.ROOT);
            String displayNameLower = stack.getDisplayName().getString().toLowerCase(Locale.ROOT);
            if (Arrays.stream(searchWords).allMatch(tipLower::contains)) return true;
            if (!Arrays.stream(searchWords).allMatch(displayNameLower::contains)) return false;
            return true;
        });
    }

    public void tick() {
        Screen screen = Minecraft.getInstance().screen;
        if (!this.canShowIn(screen)) {
            return;
        }
        if (enabled && !JeiModule.filter.getFilterText().equals(lastFilterText)) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        }
        if (enabled && screen instanceof AbstractContainerScreen) {
            this.checkSlots((AbstractContainerScreen)screen);
            this.guiOffsetX = GuiUtils.getGuiLeft((AbstractContainerScreen)screen);
            this.guiOffsetY = GuiUtils.getGuiTop((AbstractContainerScreen)screen);
        } else if (views != null) {
            views.clear();
        }
    }

    public void toggleMode() {
        if (!((Boolean)Config.search_enabled.get()).booleanValue()) {
            enabled = false;
            return;
        }
        boolean bl = enabled = !enabled;
        if (enabled) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        } else {
            lastFilterText = "";
        }
    }

    public boolean isEnabled() {
        return enabled;
    }
}

