/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui.config;

import at.ridgo8.moreoverlays.gui.config.ConfigOptionList;
import at.ridgo8.moreoverlays.gui.config.OptionValueEntry;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;

public class OptionGeneric<V>
extends OptionValueEntry<V> {
    private final EditBox tfConfigEntry;

    public OptionGeneric(ConfigOptionList list, ModConfigSpec.ConfigValue<V> valSpec, ModConfigSpec.ValueSpec spec) {
        super(list, valSpec, spec);
        this.showValidity = true;
        this.tfConfigEntry = new EditBox(Minecraft.getInstance().font, 85, 2, this.getConfigOptionList().getRowWidth() - 80 - 5 - 64, 16, Component.nullToEmpty((String)""));
        this.overrideUnsaved(this.value.get());
    }

    @Override
    protected void renderControls(GuiGraphics guiGraphics, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
        super.renderControls(guiGraphics, rowTop, rowLeft, rowWidth, itemHeight, mouseX, mouseY, mouseOver, partialTick);
        this.tfConfigEntry.render(guiGraphics, mouseX, mouseY, 0.0f);
    }

    @Override
    protected void overrideUnsaved(V value) {
        this.tfConfigEntry.setValue(value.toString());
    }

    @Override
    public List<? extends GuiEventListener> children() {
        ArrayList<GuiEventListener> childs = new ArrayList<GuiEventListener>(super.children());
        childs.add((GuiEventListener)this.tfConfigEntry);
        return childs;
    }

    public void setFocused(GuiEventListener focused) {
        super.setFocused(focused);
        if (focused == null) {
            this.tfConfigEntry.setFocused(false);
        }
    }

    public List<? extends NarratableEntry> narratables() {
        return ImmutableList.of((Object)new NarratableEntry(this){

            public NarratableEntry.NarrationPriority narrationPriority() {
                return NarratableEntry.NarrationPriority.HOVERED;
            }

            public void updateNarration(NarrationElementOutput output) {
                output.add(NarratedElementType.TITLE, "");
            }
        });
    }

    public boolean keyReleased(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean flag = super.keyReleased(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        try {
            if (this.spec.getClazz() == String.class) {
                this.updateValue(this.tfConfigEntry.getValue());
            } else if (this.value instanceof ModConfigSpec.IntValue) {
                this.updateValue(Integer.valueOf(this.tfConfigEntry.getValue()));
            } else if (this.value instanceof ModConfigSpec.DoubleValue) {
                this.updateValue(Double.valueOf(this.tfConfigEntry.getValue()));
            } else if (this.value instanceof ModConfigSpec.BooleanValue) {
                this.updateValue(Boolean.valueOf(this.tfConfigEntry.getValue()));
            }
        }
        catch (NumberFormatException e) {
            this.updateValue(null);
        }
        return flag;
    }
}

