/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui;

import at.ridgo8.moreoverlays.gui.config.ConfigOptionList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigScreen
extends Screen {
    private final String modId;
    private final ModConfigSpec configSpec;
    private final List<String> pathCache = new ArrayList<String>();
    private final Screen modListScreen;
    private ConfigOptionList optionList;
    private String categoryTitle = null;
    private Button btnReset;
    private Button btnUndo;
    private Button btnBack;
    private String txtUndo = "";
    private String txtReset = "";
    private String txtDone = "";

    public ConfigScreen(Screen modListScreen, ModConfigSpec spec, String modId) {
        super((Component)Component.translatable((String)("gui.config." + modId + ".title")));
        this.modListScreen = modListScreen;
        this.configSpec = spec;
        this.modId = modId;
        this.txtReset = I18n.get((String)"gui.config.moreoverlays.reset_config", (Object[])new Object[0]);
        this.txtUndo = I18n.get((String)"gui.config.moreoverlays.undo", (Object[])new Object[0]);
        this.txtDone = I18n.get((String)"gui.done", (Object[])new Object[0]);
    }

    protected void init() {
        int pad;
        if (this.optionList == null) {
            this.optionList = new ConfigOptionList(this.minecraft, this.modId, this);
            if (this.pathCache.isEmpty()) {
                this.optionList.setConfiguration(this.configSpec);
            } else {
                this.optionList.setConfiguration(this.configSpec, this.pathCache);
            }
        }
        Font font = Minecraft.getInstance().font;
        int undoGlyphWidth = font.width("\u21b6") * 2;
        int resetGlyphWidth = font.width("\u2604") * 2;
        int undoWidth = font.width(" " + this.txtUndo) + undoGlyphWidth + 20;
        int resetWidth = font.width(" " + this.txtReset) + resetGlyphWidth + 20;
        int doneWidth = Math.max(font.width(this.txtDone) + 20, 100);
        int buttonY = this.height - 32 + 6;
        int buttonHeight = 20;
        int xBack = pad = 10;
        int xDefaultAll = this.width - resetWidth - pad;
        int xUndoAll = xDefaultAll - undoWidth;
        this.btnReset = new Button.Builder(Component.nullToEmpty((String)("\u2604 " + this.txtReset)), btn -> this.optionList.reset()).pos(xDefaultAll, buttonY).size(100, 20).build();
        this.btnUndo = new Button.Builder(Component.nullToEmpty((String)("\u21b6 " + this.txtUndo)), btn -> this.optionList.undo()).pos(xUndoAll, buttonY).size(100, 20).build();
        this.btnBack = new Button.Builder(Component.nullToEmpty((String)(" " + this.txtDone)), btn -> this.back()).pos(xBack, buttonY).size(doneWidth, 20).build();
        this.addWidget((GuiEventListener)this.optionList);
        this.addWidget((GuiEventListener)this.btnReset);
        this.addWidget((GuiEventListener)this.btnUndo);
        this.addWidget((GuiEventListener)this.btnBack);
        this.btnReset.active = false;
        this.btnUndo.active = false;
        this.optionList.updateGui();
    }

    private void back() {
        this.save();
        if (!this.optionList.getCurrentPath().isEmpty()) {
            this.optionList.pop();
        } else {
            Minecraft.getInstance().setScreen(this.modListScreen);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (Minecraft.getInstance().level == null) {
            this.renderPanorama(guiGraphics, partialTicks);
        }
        this.renderMenuBackground(guiGraphics);
        this.renderBlurredBackground(partialTicks);
        this.optionList.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.btnReset.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.btnUndo.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.btnBack.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.getTitle(), this.width / 2, 8, 0xFFFFFF);
        if (this.categoryTitle != null) {
            guiGraphics.drawCenteredString(this.font, this.categoryTitle, this.width / 2, 24, 0xFFFFFF);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void save() {
        this.optionList.save();
        this.configSpec.save();
        this.optionList.undo();
    }

    public void tick() {
        super.tick();
        this.btnReset.active = this.optionList.isResettable();
        this.btnUndo.active = this.optionList.isUndoable();
    }

    public void updatePath(List<String> newPath) {
        String key = this.optionList.categoryTitleKey(newPath);
        this.categoryTitle = key == null ? null : I18n.get((String)key, (Object[])new Object[0]);
        this.pathCache.clear();
        this.pathCache.addAll(newPath);
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (key == 256) {
            this.back();
            return true;
        }
        return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
    }
}

