/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.chunkbounds;

import at.ridgo8.moreoverlays.chunkbounds.ChunkBoundsHandler;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4d;
import org.joml.Vector4d;

public class ChunkBoundsRenderer {
    private static final ResourceLocation BLANK_TEX = ResourceLocation.fromNamespaceAndPath((String)"moreoverlays", (String)"textures/blank.png");

    public static void renderOverlays(PoseStack matrixstack) {
        int regionZ;
        int regionX;
        LocalPlayer player = Minecraft.getInstance().player;
        Minecraft.getInstance().getTextureManager().bindForSetup(BLANK_TEX);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)((float)((Double)Config.render_chunkLineWidth.get()).doubleValue()));
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (Minecraft.getInstance().options.graphicsMode().get() != GraphicsStatus.FABULOUS) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableCull();
        }
        int h = player.level().getHeight();
        int h0 = (int)player.getY();
        int h1 = Math.min(h, h0 - 16);
        int h2 = Math.min(h, h0 + 16);
        int h3 = Math.min(h1, 0);
        int x0 = player.chunkPosition().x * 16;
        int x1 = x0 + 16;
        int x2 = x0 + 8;
        int z0 = player.chunkPosition().z * 16;
        int z1 = z0 + 16;
        int z2 = z0 + 8;
        int regionY = player.chunkPosition().getWorldPosition().getY() / 32;
        if (player.chunkPosition().x < 0) {
            regionX = (player.chunkPosition().x + 1) / 32;
            --regionX;
        } else {
            regionX = player.chunkPosition().x / 32;
        }
        if (player.chunkPosition().getWorldPosition().getY() < 0) {
            --regionY;
        }
        if (player.chunkPosition().z < 0) {
            regionZ = (player.chunkPosition().z + 1) / 32;
            --regionZ;
        } else {
            regionZ = player.chunkPosition().z / 32;
        }
        int regionBorderX0 = regionX * 32 * 16;
        int regionBorderY0 = regionY * 32 * 16 - 64;
        int regionBorderZ0 = regionZ * 32 * 16;
        int regionBorderX1 = regionBorderX0 + 512;
        int regionBorderY1 = regionBorderY0 + 512 - 128;
        int regionBorderZ1 = regionBorderZ0 + 512;
        int radius = (Integer)Config.chunk_EdgeRadius.get() * 16;
        int renderColorEdge = (Integer)Config.render_chunkEdgeColor.get();
        int renderColorMiddle = (Integer)Config.render_chunkMiddleColor.get();
        int renderColorGrid = (Integer)Config.render_chunkGridColor.get();
        for (int xo = -16 - radius; xo <= radius; xo += 16) {
            for (int yo = -16 - radius; yo <= radius; yo += 16) {
                ChunkBoundsRenderer.renderEdge(matrixstack, x0 - xo, z0 - yo, h3, h, renderColorEdge);
            }
        }
        if (((Boolean)Config.chunk_ShowMiddle.get()).booleanValue()) {
            ChunkBoundsRenderer.renderEdge(matrixstack, x2, z2, h3, h, renderColorMiddle);
        }
        if (ChunkBoundsHandler.getMode() == ChunkBoundsHandler.RenderMode.GRID) {
            ChunkBoundsRenderer.renderGrid(matrixstack, x0, h1, (float)z0 - 0.005f, x0, h2, (float)z1 + 0.005f, 1.0f, renderColorGrid);
            ChunkBoundsRenderer.renderGrid(matrixstack, x1, h1, (float)z0 - 0.005f, x1, h2, (float)z1 + 0.005f, 1.0f, renderColorGrid);
            ChunkBoundsRenderer.renderGrid(matrixstack, (float)x0 - 0.005f, h1, z0, (float)x1 + 0.005f, h2, z0, 1.0f, renderColorGrid);
            ChunkBoundsRenderer.renderGrid(matrixstack, (float)x0 - 0.005f, h1, z1, (float)x1 + 0.005f, h2, z1, 1.0f, renderColorGrid);
        } else if (ChunkBoundsHandler.getMode() == ChunkBoundsHandler.RenderMode.REGIONS) {
            ChunkBoundsRenderer.renderGrid(matrixstack, (float)regionBorderX0 - 0.005f, (float)regionBorderY0 - 0.005f, (float)regionBorderZ0 - 0.005f, (float)regionBorderX1 + 0.005f, (float)regionBorderY1 + 0.005f, (float)regionBorderZ1 + 0.005f, 16.0f, renderColorGrid);
        }
        RenderSystem.depthMask((boolean)true);
        if (Minecraft.getInstance().options.graphicsMode().get() != GraphicsStatus.FABULOUS) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableBlend();
        }
    }

    public static void renderEdge(PoseStack matrixstack, double x, double z, double h3, double h, int color) {
        Matrix4d matrix4d = new Matrix4d();
        matrixstack.last().pose().get(matrix4d);
        Tesselator tess = Tesselator.getInstance();
        Minecraft minecraft = Minecraft.getInstance();
        Camera camera = minecraft.gameRenderer.getMainCamera();
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        x -= cameraX;
        h3 -= cameraY;
        h -= cameraY;
        BufferBuilder bufferBuilder = tess.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        ChunkBoundsRenderer.drawVertex(bufferBuilder, matrix4d, x, h3, z -= cameraZ, r, g, b);
        ChunkBoundsRenderer.drawVertex(bufferBuilder, matrix4d, x, h, z, r, g, b);
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
    }

    public static void renderGrid(PoseStack matrixstack, float x0, float y0, float z0, float x1, float y1, float z1, float step, int color) {
        Matrix4d matrix4d = new Matrix4d();
        matrixstack.last().pose().get(matrix4d);
        Tesselator tess = Tesselator.getInstance();
        Minecraft minecraft = Minecraft.getInstance();
        Camera camera = minecraft.gameRenderer.getMainCamera();
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        BufferBuilder renderer = tess.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        for (float x = x0; x <= x1; x += step) {
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x - cameraX, (double)y0 - cameraY, (double)z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x - cameraX, (double)y1 - cameraY, (double)z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x - cameraX, (double)y0 - cameraY, (double)z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x - cameraX, (double)y1 - cameraY, (double)z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x - cameraX, (double)y0 - cameraY, (double)z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x - cameraX, (double)y0 - cameraY, (double)z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x - cameraX, (double)y1 - cameraY, (double)z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x - cameraX, (double)y1 - cameraY, (double)z1 - cameraZ, r, g, b);
        }
        for (float y = y0; y <= y1; y += step) {
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x0 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x1 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x0 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x1 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x0 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x0 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x1 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x1 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
        }
        for (float z = z0; z <= z1; z += step) {
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x0 - cameraX, (double)y0 - cameraY, (double)z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x1 - cameraX, (double)y0 - cameraY, (double)z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x0 - cameraX, (double)y1 - cameraY, (double)z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x1 - cameraX, (double)y1 - cameraY, (double)z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x0 - cameraX, (double)y0 - cameraY, (double)z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x0 - cameraX, (double)y1 - cameraY, (double)z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x1 - cameraX, (double)y0 - cameraY, (double)z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, (double)x1 - cameraX, (double)y1 - cameraY, (double)z - cameraZ, r, g, b);
        }
        MeshData meshData = renderer.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
    }

    private static void drawVertex(BufferBuilder renderer, Matrix4d matrix, double x, double y, double z, float r, float g, float b) {
        Vector4d vector4d = matrix.transform(new Vector4d(x, y, z, 1.0));
        renderer.addVertex((float)vector4d.x(), (float)vector4d.y(), (float)vector4d.z()).setColor(r, g, b, 1.0f);
    }
}

