/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays;

import at.ridgo8.moreoverlays.KeyBindings;
import at.ridgo8.moreoverlays.chunkbounds.ChunkBoundsHandler;
import at.ridgo8.moreoverlays.config.Config;
import at.ridgo8.moreoverlays.gui.ConfigScreen;
import at.ridgo8.moreoverlays.itemsearch.GuiHandler;
import at.ridgo8.moreoverlays.itemsearch.GuiUtils;
import at.ridgo8.moreoverlays.lightoverlay.LightOverlayHandler;
import at.ridgo8.moreoverlays.lightoverlay.integration.AlternateLightHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@EventBusSubscriber(modid="moreoverlays", bus=EventBusSubscriber.Bus.GAME)
public final class ClientRegistrationHandler {
    private static boolean enable_jei = false;

    private ClientRegistrationHandler() {
    }

    public static boolean isJeiInstalled() {
        return enable_jei;
    }

    public static void setupClient() {
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.registerExtensionPoint(IConfigScreenFactory.class, () -> (minecraft, screen) -> new ConfigScreen(screen, Config.config_client, "moreoverlays"));
        enable_jei = ModList.get().isLoaded("jei");
        LightOverlayHandler.init();
        ChunkBoundsHandler.init();
        GuiUtils.initUtil();
        AlternateLightHandler.init();
        GuiHandler.init();
        if (!((Boolean)Config.light_FinishedMigration.get()).booleanValue()) {
            Config.light_SaveLevel.set((Object)1);
            Config.light_FinishedMigration.set((Object)true);
        }
    }

    public static Screen openSettings(Minecraft mc, Screen modlist) {
        return new ConfigScreen(modlist, Config.config_client, "moreoverlays");
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        ClientRegistrationHandler.checkAndToggleKeyMappings();
    }

    private static void checkAndToggleKeyMappings() {
        if (((KeyMapping)KeyBindings.lightOverlayKeyMapping.get()).consumeClick()) {
            LightOverlayHandler.setEnabled(!LightOverlayHandler.isEnabled());
        }
        if (((KeyMapping)KeyBindings.chunkBoundsKeyMapping.get()).consumeClick()) {
            ChunkBoundsHandler.toggleMode();
        }
    }
}

