/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import gripe._90.megacells.misc.DecompressionPattern;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public class CompressionChain {
    public static final StreamCodec<RegistryFriendlyByteBuf, CompressionChain> STREAM_CODEC = Variant.STREAM_CODEC.apply(ByteBufCodecs.list()).map(CompressionChain::new, chain -> chain.variants);
    public static final long STACK_LIMIT = (long)Math.pow(2.0, 42.0);
    private final List<Variant> variants;
    private final Lazy<List<Pair<IPatternDetails, IPatternDetails>>> patterns = Lazy.of(this::gatherPatterns);

    CompressionChain(List<Variant> variants) {
        this.variants = Collections.unmodifiableList(variants);
    }

    public static long clamp(BigInteger toClamp, long limit) {
        return toClamp.min(BigInteger.valueOf(limit)).longValue();
    }

    public boolean isEmpty() {
        return this.variants.isEmpty();
    }

    public boolean containsVariant(Item item) {
        for (Variant variant : this.variants) {
            if (!variant.item.equals(item)) continue;
            return true;
        }
        return false;
    }

    public Item getItem(int index) {
        return this.variants.get((int)index).item;
    }

    public BigInteger unitFactor(Item item) {
        if (item == null) {
            return BigInteger.ONE;
        }
        BigInteger potentialFactor = BigInteger.ONE;
        for (Variant variant : this.variants) {
            potentialFactor = potentialFactor.multiply(variant.big());
            if (!variant.item.equals(item)) continue;
            return potentialFactor;
        }
        return BigInteger.ONE;
    }

    public int size() {
        return this.variants.size();
    }

    public List<IPatternDetails> getDecompressionPatterns(int cutoff) {
        int i;
        if (this.isEmpty()) {
            return List.of();
        }
        ObjectArrayList decompressionPatterns = new ObjectArrayList();
        List availablePatterns = (List)this.patterns.get();
        for (i = 0; i < this.variants.subList(0, cutoff).size(); ++i) {
            decompressionPatterns.add((Object)((IPatternDetails)((Pair)availablePatterns.get(i)).right()));
        }
        for (i = cutoff; i < this.variants.size() - 1; ++i) {
            decompressionPatterns.add((Object)((IPatternDetails)((Pair)availablePatterns.get(i)).left()));
        }
        return Collections.unmodifiableList(decompressionPatterns);
    }

    private List<Pair<IPatternDetails, IPatternDetails>> gatherPatterns() {
        ObjectArrayList patterns = new ObjectArrayList();
        for (int i = 0; i < this.variants.size() - 1; ++i) {
            Variant smaller = this.variants.get(i);
            Variant larger = this.variants.get(i + 1);
            DecompressionPattern compression = new DecompressionPattern(smaller.item, larger.item, larger.factor, true);
            DecompressionPattern decompression = new DecompressionPattern(larger.item, smaller.item, larger.factor, false);
            patterns.add((Object)Pair.of((Object)compression, (Object)decompression));
        }
        return patterns;
    }

    public Map<Item, Long> initStacks(BigInteger unitCount, int cutoff, Item fallback) {
        Object2LongLinkedOpenHashMap stacks = new Object2LongLinkedOpenHashMap();
        if (this.isEmpty()) {
            if (fallback != null) {
                stacks.put((Object)fallback, CompressionChain.clamp(unitCount, STACK_LIMIT));
            }
            return stacks;
        }
        for (int i = 0; i < cutoff + 1; ++i) {
            Variant variant = this.variants.get(i);
            if (i >= cutoff) {
                stacks.put((Object)variant.item(), CompressionChain.clamp(unitCount, STACK_LIMIT));
                break;
            }
            BigInteger factor = this.variants.get((i + 1) % this.variants.size()).big();
            stacks.put((Object)variant.item(), unitCount.remainder(factor).longValue());
            unitCount = unitCount.divide(factor);
        }
        return stacks;
    }

    public void updateStacks(Map<Item, Long> stackMap, BigInteger unitsToAdd, int cutoff) {
        if (this.isEmpty()) {
            if (stackMap.size() > 1) {
                throw new IllegalStateException("Bulk cell reported more than one stack for empty compression chain");
            }
            if (!stackMap.isEmpty()) {
                Item item = stackMap.keySet().iterator().next();
                BigInteger amount = BigInteger.valueOf(stackMap.get(item));
                stackMap.put(item, CompressionChain.clamp(amount.add(unitsToAdd), STACK_LIMIT));
            }
            return;
        }
        for (int i = 0; i < cutoff + 1; ++i) {
            BigInteger factor;
            Variant variant = this.variants.get(i);
            BigInteger amount = BigInteger.valueOf(stackMap.get(variant.item));
            if (unitsToAdd.signum() != 0 && i < cutoff) {
                factor = this.variants.get((i + 1) % this.variants.size()).big();
                BigInteger added = unitsToAdd.remainder(factor);
                amount = amount.add(added);
                unitsToAdd = unitsToAdd.subtract(added);
                if (amount.signum() == -1 || amount.divide(factor).signum() == 1) {
                    BigInteger outflow = amount.add(factor).remainder(factor);
                    unitsToAdd = unitsToAdd.add(amount.subtract(outflow));
                    amount = outflow;
                }
            } else {
                stackMap.put(variant.item, CompressionChain.clamp(amount.add(unitsToAdd), STACK_LIMIT));
                break;
            }
            stackMap.put(variant.item, amount.longValue());
            unitsToAdd = unitsToAdd.divide(factor);
        }
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass() && ((CompressionChain)o).variants.equals(this.variants);
    }

    public int hashCode() {
        return Objects.hashCode(this.variants);
    }

    record Variant(Item item, int factor) {
        private static final StreamCodec<RegistryFriendlyByteBuf, Variant> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), Variant::item, (StreamCodec)ByteBufCodecs.VAR_INT, Variant::factor, Variant::new);

        private BigInteger big() {
            return BigInteger.valueOf(this.factor);
        }

        @Override
        @NotNull
        public String toString() {
            return this.factor + "x \u2192 " + String.valueOf(this.item);
        }
    }
}

