/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleBlockBlockReader
implements BlockGetter {
    protected final BlockState state;
    protected final Block blk;
    protected final BlockPos pos;
    protected final BlockGetter source;

    public SingleBlockBlockReader(BlockState state, Block blk) {
        this.state = state;
        this.blk = blk;
        this.pos = BlockPos.ZERO;
        this.source = null;
    }

    public SingleBlockBlockReader(BlockState state) {
        this.state = state;
        this.blk = state.getBlock();
        this.pos = BlockPos.ZERO;
        this.source = null;
    }

    public SingleBlockBlockReader(BlockState state, Block blk, BlockPos pos) {
        this.state = state;
        this.blk = blk;
        this.pos = pos;
        this.source = null;
    }

    public SingleBlockBlockReader(BlockState state, BlockPos pos) {
        this.state = state;
        this.blk = state.getBlock();
        this.pos = pos;
        this.source = null;
    }

    public SingleBlockBlockReader(BlockState state, Block blk, BlockGetter source) {
        this.state = state;
        this.blk = blk;
        this.source = source;
        this.pos = BlockPos.ZERO;
    }

    public SingleBlockBlockReader(BlockState state, BlockGetter source) {
        this.state = state;
        this.blk = state.getBlock();
        this.source = source;
        this.pos = BlockPos.ZERO;
    }

    public SingleBlockBlockReader(BlockState state, Block blk, BlockPos pos, BlockGetter source) {
        this.state = state;
        this.blk = blk;
        this.pos = pos;
        this.source = source;
    }

    public SingleBlockBlockReader(BlockState state, BlockPos pos, BlockGetter source) {
        this.state = state;
        this.blk = state.getBlock();
        this.pos = pos;
        this.source = source;
    }

    @Nullable
    public BlockEntity getBlockEntity(@NotNull BlockPos pos) {
        if (pos == this.pos && this.blk instanceof EntityBlock) {
            return ((EntityBlock)this.blk).newBlockEntity(this.pos, this.state);
        }
        return this.source == null ? null : this.source.getBlockEntity(pos);
    }

    @NotNull
    public BlockState getBlockState(@NotNull BlockPos pos) {
        if (pos == this.pos) {
            return this.state;
        }
        return this.source == null ? Blocks.AIR.defaultBlockState() : this.source.getBlockState(pos);
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    public int getHeight() {
        return 0;
    }

    public int getMinBuildHeight() {
        return 0;
    }
}

