/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.trapdoor;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import com.ldtteam.domumornamentum.util.Constants;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class TrapdoorsBlockStateProvider
extends BlockStateProvider {
    public TrapdoorsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createBlockstateFile(ModBlocks.getInstance().getTrapdoor());
    }

    private void createBlockstateFile(TrapdoorBlock trapdoor) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)trapdoor);
        for (Direction facingValue : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
            for (TrapdoorType typeValue : TrapdoorBlock.TYPE.getPossibleValues()) {
                for (Half halfValue : TrapDoorBlock.HALF.getPossibleValues()) {
                    Iterator iterator = BlockStateProperties.OPEN.getPossibleValues().iterator();
                    while (iterator.hasNext()) {
                        boolean openValue = (Boolean)iterator.next();
                        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/trapdoor/trapdoor_" + typeValue.getSerializedName(), this.modLoc("block/trapdoor/trapdoor_" + typeValue.getSerializedName() + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end()).uvLock(true).rotationY(this.getYFromFacing(facingValue) + this.getYFromOpenAndHalf(openValue, halfValue)).rotationX(this.getXFromOpenAndHalf(openValue, halfValue)).addModel()).condition((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable[])new Direction[]{facingValue}).condition(TrapdoorBlock.TYPE, (Comparable[])new TrapdoorType[]{typeValue}).condition((Property)TrapDoorBlock.HALF, (Comparable[])new Half[]{halfValue}).condition((Property)BlockStateProperties.OPEN, (Comparable[])new Boolean[]{openValue}).end();
                    }
                }
            }
        }
        ItemModelBuilder itemModelBuilderSpec = (ItemModelBuilder)this.itemModels().withExistingParent(ModBlocks.getInstance().getTrapdoor().getRegistryName().getPath() + "_spec", this.mcLoc("block/thin_block"));
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilderSpec);
        for (int i = 0; i < TrapdoorType.values().length; ++i) {
            TrapdoorType type = TrapdoorType.values()[i];
            itemModelBuilderSpec.override().model((ModelFile)this.itemModels().getExistingFile(this.modLoc("block/trapdoor/trapdoor_" + type.getSerializedName() + "_spec"))).predicate(Constants.TRAPDOOR_MODEL_OVERRIDE, (float)i).end();
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getTrapdoor().getRegistryName().getPath())).parent((ModelFile)itemModelBuilderSpec)).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
    }

    private int getYFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 0 : 180;
        }
        return half == Half.TOP ? 180 : 0;
    }

    private int getXFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 180 : 0;
        }
        return half == Half.TOP ? -90 : 90;
    }

    @NotNull
    public String getName() {
        return "Trapdoors BlockStates Provider";
    }
}

