/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.global;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.BrickBlock;
import com.ldtteam.domumornamentum.block.decorative.ExtraBlock;
import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.ldtteam.domumornamentum.datagen.loot.MaterialLootTableProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;

public class GlobalLootTableProvider
extends LootTableProvider {
    public GlobalLootTableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(GlobalLootTableEntries::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(MaterialLootTableProvider::new, LootContextParamSets.BLOCK)), provider);
    }

    @NotNull
    public String getName() {
        return "Default Block Loot Tables Provider";
    }

    private static final class GlobalLootTableEntries
    extends BlockLootSubProvider {
        private GlobalLootTableEntries(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            for (BrickBlock brickBlock : ModBlocks.getInstance().getBricks()) {
                this.dropSelf(brickBlock);
            }
            for (ExtraBlock extraBlock : ModBlocks.getInstance().getExtraTopBlocks()) {
                this.dropSelf(extraBlock);
            }
            for (FloatingCarpetBlock floatingCarpetBlock : ModBlocks.getInstance().getFloatingCarpets()) {
                this.dropSelf(floatingCarpetBlock);
            }
            this.dropSelf(ModBlocks.getInstance().getStandingBarrel());
            this.dropSelf(ModBlocks.getInstance().getLayingBarrel());
            this.dropSelf(ModBlocks.getInstance().getArchitectsCutter());
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return ImmutableList.builder().addAll(ModBlocks.getInstance().getBricks()).addAll(ModBlocks.getInstance().getExtraTopBlocks()).addAll(ModBlocks.getInstance().getFloatingCarpets()).add((Object)ModBlocks.getInstance().getStandingBarrel()).add((Object)ModBlocks.getInstance().getLayingBarrel()).add((Object)ModBlocks.getInstance().getArchitectsCutter()).build();
        }
    }
}

