/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.baked;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.client.model.baked.RetexturedBakedModelBuilder;
import com.ldtteam.domumornamentum.client.model.baked.SpecificRenderTypeBakedModelWrapper;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.client.model.properties.ModProperties;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MateriallyTexturedBakedModel
implements BakedModel {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final RandomSource RANDOM = RandomSource.createThreadSafe();
    private static final ChunkRenderTypeSet SOLID_ONLY = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.solid()});
    private final Cache<BlockModelCacheKey, BakedModel> cache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).concurrencyLevel(4).maximumSize(10000L).build();
    private final Cache<ItemModelCacheKey, BakedModel> itemCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).concurrencyLevel(4).maximumSize(10000L).build();
    private final BakedModel innerModel;

    public MateriallyTexturedBakedModel(BakedModel innerModel) {
        this.innerModel = innerModel;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.innerModel.getQuads(state, side, rand);
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (!data.has(ModProperties.MATERIAL_TEXTURE_PROPERTY)) {
            return ChunkRenderTypeSet.none();
        }
        MaterialTextureData textureData = (MaterialTextureData)data.get(ModProperties.MATERIAL_TEXTURE_PROPERTY);
        if (textureData == null) {
            return ChunkRenderTypeSet.none();
        }
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])((ChunkRenderTypeSet[])Stream.concat(textureData.getTexturedComponents().values().stream().map(block -> Minecraft.getInstance().getBlockRenderer().getBlockModel(block.defaultBlockState()).getRenderTypes(block.defaultBlockState(), rand, ModelData.EMPTY)), Stream.of(SOLID_ONLY)).toArray(ChunkRenderTypeSet[]::new)));
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        BakedModel remappedModel = this.getBakedInnerModelFor(data, state, renderType == null ? RenderType.solid() : renderType);
        return remappedModel.getQuads(state, side, rand, data, renderType);
    }

    public boolean useAmbientOcclusion() {
        return this.innerModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.innerModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.innerModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.innerModel.isCustomRenderer();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.innerModel.getParticleIcon();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData modelData) {
        if (!modelData.has(ModProperties.MATERIAL_TEXTURE_PROPERTY)) {
            return this.getParticleIcon();
        }
        MaterialTextureData textureData = (MaterialTextureData)modelData.get(ModProperties.MATERIAL_TEXTURE_PROPERTY);
        if (textureData == null) {
            return this.getParticleIcon();
        }
        ResourceLocation particleTextureName = this.getParticleIcon().contents().name();
        if (!textureData.getTexturedComponents().containsKey(particleTextureName)) {
            return this.getParticleIcon();
        }
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(textureData.getTexturedComponents().get(particleTextureName).defaultBlockState()).getParticleIcon(modelData);
    }

    @NotNull
    public ItemTransforms getTransforms() {
        return this.innerModel.getTransforms();
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    @NotNull
    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        Item item = itemStack.getItem();
        if (!(item instanceof BlockItem)) {
            return Collections.emptyList();
        }
        BlockItem blockItem = (BlockItem)item;
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(itemStack);
        if (textureData.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(this.getRenderTypes(blockItem, textureData));
    }

    private Collection<RenderType> getRenderTypes(BlockItem blockItem, MaterialTextureData textureData) {
        List renderTypes = this.getRenderTypes(blockItem.getBlock().defaultBlockState(), RANDOM, ModelData.builder().with(ModProperties.MATERIAL_TEXTURE_PROPERTY, (Object)textureData).build()).asList();
        HashSet<RenderType> renderTypesWithAdditionalComponents = new HashSet<RenderType>(renderTypes);
        renderTypesWithAdditionalComponents.add(RenderType.solid());
        return renderTypesWithAdditionalComponents;
    }

    @NotNull
    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        Collection<RenderType> renderTypes;
        Item item = itemStack.getItem();
        if (!(item instanceof BlockItem)) {
            return Collections.emptyList();
        }
        BlockItem blockItem = (BlockItem)item;
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(itemStack);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(itemStack);
        }
        if ((renderTypes = this.getRenderTypes(blockItem, textureData)).isEmpty()) {
            return Collections.emptyList();
        }
        MaterialTextureData finalTextureData = textureData;
        ArrayList<BakedModel> models = new ArrayList<BakedModel>();
        renderTypes.stream().map(type -> MateriallyTexturedBakedModel.getRenderType(type, fabulous)).distinct().map(type -> new SpecificRenderTypeBakedModelWrapper((RenderType)type, this.getBakedInnerModelFor(itemStack, finalTextureData, blockItem.getBlock().defaultBlockState(), (RenderType)type))).forEach(models::add);
        return models;
    }

    private BakedModel getBakedInnerModelFor(ModelData modelData, BlockState sourceState, RenderType renderType) {
        if (!modelData.has(ModProperties.MATERIAL_TEXTURE_PROPERTY)) {
            return this.getBakedInnerModelFor(MaterialTextureData.EMPTY, sourceState, renderType);
        }
        return this.getBakedInnerModelFor((MaterialTextureData)modelData.get(ModProperties.MATERIAL_TEXTURE_PROPERTY), sourceState, renderType);
    }

    private BakedModel getBakedInnerModelFor(MaterialTextureData modelData, BlockState sourceState, RenderType renderType) {
        try {
            BlockModelCacheKey key = new BlockModelCacheKey(modelData, renderType);
            return (BakedModel)this.cache.get((Object)key, () -> {
                RetexturedBakedModelBuilder builder = RetexturedBakedModelBuilder.createFor(sourceState, renderType, false, this.innerModel);
                modelData.getTexturedComponents().forEach(builder::with);
                return builder.build();
            });
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Failed to build baked materially textured model for: %s %s", sourceState, modelData), (Throwable)exception);
            return Minecraft.getInstance().getModelManager().getMissingModel();
        }
    }

    private BakedModel getBakedInnerModelFor(ItemStack stack, MaterialTextureData textureData, BlockState blockState, RenderType renderType) {
        try {
            ItemModelCacheKey key = new ItemModelCacheKey(textureData, renderType, (BlockItemStateProperties)stack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY));
            return (BakedModel)this.itemCache.get((Object)key, () -> {
                RetexturedBakedModelBuilder builder = RetexturedBakedModelBuilder.createFor(blockState, renderType, true, this.innerModel.getOverrides().resolve(this.innerModel, stack, null, null, 0));
                textureData.getTexturedComponents().forEach(builder::with);
                return builder.build();
            });
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Failed to build baked materially textured model for: %s for item: %s", textureData, stack), (Throwable)exception);
            return Minecraft.getInstance().getModelManager().getMissingModel();
        }
    }

    public static RenderType getRenderType(RenderType renderType, boolean fabulous) {
        if (renderType == RenderType.translucent()) {
            if (!Minecraft.useShaderTransparency()) {
                return Sheets.translucentCullBlockSheet();
            }
            return fabulous ? Sheets.translucentCullBlockSheet() : Sheets.translucentItemSheet();
        }
        return Sheets.cutoutBlockSheet();
    }

    public static RenderType getFabulousRenderType(RenderType renderType) {
        if (renderType == RenderType.translucent()) {
            return Sheets.translucentCullBlockSheet();
        }
        return Sheets.cutoutBlockSheet();
    }

    public static RenderType getNoneFabulousRenderType(RenderType renderType) {
        if (renderType == RenderType.translucent()) {
            return !Minecraft.useShaderTransparency() ? Sheets.translucentCullBlockSheet() : Sheets.translucentItemSheet();
        }
        return Sheets.cutoutBlockSheet();
    }

    private record BlockModelCacheKey(MaterialTextureData data, RenderType renderType) {
    }

    private record ItemModelCacheKey(MaterialTextureData data, RenderType renderType, BlockItemStateProperties blockStateProperties) {
    }
}

