/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.AbstractPanelBlockTrapdoor;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipeBuilder;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PanelBlock
extends AbstractPanelBlockTrapdoor<PanelBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final MapCodec<PanelBlock> CODEC = PanelBlock.simpleCodec(PanelBlock::new);
    public static final EnumProperty<TrapdoorType> TYPE = EnumProperty.create((String)"type", TrapdoorType.class);
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(ResourceLocation.withDefaultNamespace((String)"block/oak_planks"), ModTags.TRAPDOORS_MATERIALS, Blocks.OAK_PLANKS)).build();
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public PanelBlock() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(3.0f).noOcclusion().isValidSpawn((state, blockGetter, pos, type) -> false));
    }

    public PanelBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)TrapdoorType.FULL)));
    }

    protected MapCodec<PanelBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    @Override
    public void fillItemCategory(@NotNull NonNullList<ItemStack> items) {
        if (!this.fillItemGroupCache.isEmpty()) {
            items.addAll(this.fillItemGroupCache);
            return;
        }
        try {
            for (TrapdoorType trapdoorType : TrapdoorType.values()) {
                ItemStack result = new ItemStack((ItemLike)this);
                BlockUtils.putPropertyIntoBlockStateTag(result, TYPE, trapdoorType);
                this.fillItemGroupCache.add(result);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(this.fillItemGroupCache);
    }

    @Override
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        Vec3 offsetPos = context.getClickLocation().subtract(Vec3.atLowerCornerOf((Vec3i)context.getClickedPos()));
        if (context.getClickedFace().getAxis().isHorizontal()) {
            if (offsetPos.y > 0.8) {
                return (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
            }
            if (offsetPos.y < 0.2) {
                return (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)HALF, (Comparable)Half.BOTTOM);
            }
            if (context.getClickedFace().getAxis() == Direction.Axis.X) {
                if (offsetPos.z > 0.8) {
                    return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
                }
                if (offsetPos.z < 0.2) {
                    return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.SOUTH);
                }
            } else {
                if (offsetPos.x > 0.8) {
                    return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.WEST);
                }
                if (offsetPos.x < 0.2) {
                    return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.EAST);
                }
            }
        } else {
            if (offsetPos.z > 0.8) {
                return (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (offsetPos.z < 0.2) {
                return (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.SOUTH);
            }
            if (offsetPos.x > 0.8) {
                return (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.WEST);
            }
            if (offsetPos.x < 0.2) {
                return (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.EAST);
            }
        }
        return state;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack(world.getBlockEntity(pos), (HolderLookup.Provider)world.registryAccess(), new Property[]{TYPE});
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @Override
    public void buildRecipes(RecipeOutput recipeOutput) {
        for (TrapdoorType value : TrapdoorType.values()) {
            new ArchitectsCutterRecipeBuilder(this, RecipeCategory.DECORATIONS).resultProperty(TYPE, value).count(COMPONENTS.size() * 4).saveSuffix(recipeOutput, value.getSerializedName());
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getDOExplosionResistance((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getExplosionResistance(x$0, x$1, x$2, x$3)), state, level, pos, explosion);
    }

    public float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getDODestroyProgress((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getDestroyProgress(x$0, x$1, x$2, x$3)), state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getDOSoundType((x$0, x$1, x$2, x$3) -> super.getSoundType(x$0, x$1, x$2, x$3), state, level, pos, entity);
    }

    @Override
    public IMateriallyTexturedBlockComponent getMainComponent() {
        return COMPONENTS.get(0);
    }
}

