/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.entities.RoboBeeEntity;
import de.theidler.create_mobile_packages.entities.models.RoboBeeModel;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class DroneEntityRenderer
extends MobRenderer<RoboBeeEntity, RoboBeeModel<RoboBeeEntity>> {
    private static final ResourceLocation TEXTURE = CreateMobilePackages.asResource("textures/entity/robo_bee.png");

    public DroneEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new RoboBeeModel(pContext.bakeLayer(RoboBeeModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(RoboBeeEntity pEntity) {
        return TEXTURE;
    }

    public void render(RoboBeeEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        ItemStack stack = entity.getItemStack();
        if (!PackageItem.isPackage((ItemStack)stack)) {
            return;
        }
        ResourceLocation modelKey = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        float riggingOffset = PackageItem.getHookDistance((ItemStack)stack);
        float heightScale = entity.getPackageHeightScale().floatValue();
        poseStack.pushPose();
        poseStack.translate(-0.5, (double)(0.0f - (riggingOffset - 0.3125f) * heightScale), -0.5);
        poseStack.scale(1.0f, heightScale * 1.0f, 1.0f);
        BakedModel rig = ((PartialModel)AllPartialModels.PACKAGE_RIGGING.get(modelKey)).get();
        Minecraft.getInstance().getItemRenderer().renderModelLists(rig, ItemStack.EMPTY, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer.getBuffer(ItemBlockRenderTypes.getRenderType((ItemStack)ItemStack.EMPTY, (boolean)true)));
        poseStack.popPose();
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.0, (double)(0.0f - (riggingOffset - 1.0f + 0.1875f) * heightScale), 0.0);
            poseStack.scale(2.0f, heightScale * 2.0f, 2.0f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), entity.getId());
            poseStack.popPose();
        }
    }
}

