/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.blocks.bee_port;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlock;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortMenu;
import de.theidler.create_mobile_packages.blocks.bee_port.DronePortTracker;
import de.theidler.create_mobile_packages.entities.RoboBeeEntity;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntity;
import de.theidler.create_mobile_packages.entities.robo_entity.states.AdjustRotationToTarget;
import de.theidler.create_mobile_packages.index.CMPBlockEntities;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import de.theidler.create_mobile_packages.items.robo_bee.RoboBeeItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BeePortBlockEntity
extends PackagePortBlockEntity {
    private final ContainerData data = new SimpleContainerData(2);
    private final ItemStackHandler roboBeeInventory = new ItemStackHandler(1);
    private final IItemHandler handler = new IItemHandler(){

        public int getSlots() {
            return BeePortBlockEntity.this.inventory.getSlots() + BeePortBlockEntity.this.roboBeeInventory.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.getStackInSlot(slot);
            }
            return BeePortBlockEntity.this.roboBeeInventory.getStackInSlot(slot - BeePortBlockEntity.this.inventory.getSlots());
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.getItem() instanceof RoboBeeItem) {
                if (slot >= BeePortBlockEntity.this.inventory.getSlots()) {
                    return BeePortBlockEntity.this.roboBeeInventory.insertItem(slot - BeePortBlockEntity.this.inventory.getSlots(), stack, simulate);
                }
                return stack;
            }
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.extractItem(slot, amount, simulate);
            }
            return BeePortBlockEntity.this.roboBeeInventory.extractItem(slot - BeePortBlockEntity.this.inventory.getSlots(), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.getSlotLimit(slot);
            }
            return BeePortBlockEntity.this.roboBeeInventory.getSlotLimit(slot - BeePortBlockEntity.this.inventory.getSlots());
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (stack.getItem() instanceof RoboBeeItem) {
                if (slot >= BeePortBlockEntity.this.inventory.getSlots()) {
                    return BeePortBlockEntity.this.roboBeeInventory.isItemValid(slot - BeePortBlockEntity.this.inventory.getSlots(), stack);
                }
                return false;
            }
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.isItemValid(slot, stack);
            }
            return false;
        }
    };
    private int tickCounter = 0;
    private int sendItemThisTime = 0;
    private RoboEntity entityOnTravel = null;

    public BeePortBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CMPBlockEntities.BEE_PORT.get(), (be, context) -> be.handler);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("RoboBeeInventory", (Tag)this.roboBeeInventory.serializeNBT(registries));
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (tag.contains("RoboBeeInventory")) {
            this.roboBeeInventory.deserializeNBT(registries, tag.getCompound("RoboBeeInventory"));
        }
    }

    public void tick() {
        super.tick();
        if (++this.tickCounter % 20 == 0) {
            this.processItems();
        }
        if (!this.level.isClientSide()) {
            if (this.getRoboEntity() != null) {
                this.data.set(0, RoboEntity.calcETA(this.getBlockPos().getCenter(), this.getRoboEntity().position()));
            }
            this.data.set(1, this.entityOnTravel != null ? 1 : 0);
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.tryPullingFromAdjacentInventories();
        if (this.level != null && this.level.hasNeighborSignal(this.worldPosition)) {
            this.tryPushingToAdjacentInventories();
        }
    }

    private void tryPushingToAdjacentInventories() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (!PackageItem.isPackage((ItemStack)itemStack) || !PackageItem.matchAddress((ItemStack)itemStack, (String)this.addressFilter)) continue;
            for (IItemHandler adjacentInventory : this.getAdjacentInventories()) {
                if (!this.tryPushingToInventory(adjacentInventory, itemStack, i)) continue;
                return;
            }
        }
    }

    private boolean tryPushingToInventory(IItemHandler inventory, ItemStack itemStack, int extractSlot) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).isEmpty()) continue;
            inventory.insertItem(i, this.inventory.extractItem(extractSlot, 1, false), false);
            return true;
        }
        return false;
    }

    private void tryPullingFromAdjacentInventories() {
        if (this.hasFullInventory(this.entityOnTravel != null ? 1 : 0)) {
            return;
        }
        this.getAdjacentInventories().forEach(inventory -> {
            if (inventory == null) {
                return;
            }
            if (this.hasFullInventory(this.entityOnTravel != null ? 1 : 0)) {
                return;
            }
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack itemStack = inventory.getStackInSlot(i);
                if (itemStack.isEmpty() || !PackageItem.isPackage((ItemStack)itemStack)) continue;
                this.addItemStack(inventory.extractItem(i, 1, false));
            }
        });
    }

    private List<IItemHandler> getAdjacentInventories() {
        ArrayList<IItemHandler> inventories = new ArrayList<IItemHandler>();
        for (Direction side : Direction.values()) {
            IItemHandler inventory = this.getAdjacentInventory(side);
            if (inventory == null) continue;
            inventories.add(inventory);
        }
        return inventories;
    }

    private IItemHandler getAdjacentInventory(Direction side) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(side));
        if (blockEntity == null || blockEntity instanceof FrogportBlockEntity) {
            return null;
        }
        return (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), (Object)side.getOpposite());
    }

    private void processItems() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.sendItemThisTime-- > 0) {
                return;
            }
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            this.sendItem(itemStack, i);
        }
    }

    private void sendItem(ItemStack itemStack, int slot) {
        BeePortBlockEntity beePortBlockEntity;
        if (this.level == null || !PackageItem.isPackage((ItemStack)itemStack)) {
            return;
        }
        String address = PackageItem.getAddress((ItemStack)itemStack);
        for (Player player : this.level.players()) {
            if (!BeePortBlockEntity.doesAddressStringMatchPlayerName(player, address) || !RoboEntity.isWithinRange(player.blockPosition(), this.getBlockPos())) continue;
            this.sendToPlayer(player, itemStack, slot);
            return;
        }
        if (((Boolean)CMPConfigs.server().portToPort.get()).booleanValue() && !PackageItem.matchAddress((String)address, (String)this.addressFilter) && (beePortBlockEntity = RoboEntity.getClosestBeePort(this.level, address, this.getBlockPos(), null)) != null && !beePortBlockEntity.isFull()) {
            this.sendDrone(itemStack, slot);
        }
    }

    public static boolean doesAddressStringMatchPlayerName(Player player, String address) {
        String playerName = player.getName().getString();
        int atIndex = address.lastIndexOf(64);
        if (atIndex == -1) {
            return address.equals(playerName);
        }
        return address.substring(atIndex + 1).equals(playerName);
    }

    private static void requestRoboEntity(Level level, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DronePortTracker tracker = DronePortTracker.get(serverLevel);
            ArrayList<BeePortBlockEntity> allBEs = new ArrayList<BeePortBlockEntity>(tracker.getAll());
            allBEs.removeIf(be -> be.getBlockPos().equals((Object)blockPos));
            allBEs.removeIf(be -> be.getRoboBeeInventory().getStackInSlot(0).getCount() <= 0);
            BeePortBlockEntity target = allBEs.stream().min(Comparator.comparingDouble(a -> a.getBlockPos().distSqr((Vec3i)blockPos))).orElse(null);
            if (target != null) {
                target.sendDrone(blockPos, true);
            }
        }
    }

    private void sendToPlayer(Player player, ItemStack itemStack, int slot) {
        if (this.roboBeeInventory.getStackInSlot(0).getCount() <= 0) {
            if (this.entityOnTravel == null) {
                BeePortBlockEntity.requestRoboEntity(this.level, this.getBlockPos());
                return;
            }
            return;
        }
        this.sendItemThisTime = 2;
        CreateMobilePackages.LOGGER.info("Sending package to player: {}", (Object)player.getName().getString());
        this.sendDrone(itemStack, slot);
    }

    private void sendDrone(ItemStack itemStack, int slot) {
        if (this.roboBeeInventory.getStackInSlot(0).getCount() <= 0) {
            if (this.entityOnTravel == null) {
                BeePortBlockEntity.requestRoboEntity(this.level, this.getBlockPos());
                return;
            }
            return;
        }
        this.sendItemThisTime = 2;
        RoboBeeEntity drone = new RoboBeeEntity(this.level, itemStack, null, this.getBlockPos());
        this.level.addFreshEntity((Entity)drone);
        drone.setRequest(false);
        this.roboBeeInventory.getStackInSlot(0).shrink(1);
        this.inventory.setStackInSlot(slot, ItemStack.EMPTY);
    }

    private void sendDrone(BlockPos tagetPos, boolean request) {
        if (this.roboBeeInventory.getStackInSlot(0).getCount() <= 0) {
            return;
        }
        this.sendItemThisTime = 2;
        RoboBeeEntity drone = new RoboBeeEntity(this.level, ItemStack.EMPTY, tagetPos, this.getBlockPos());
        this.level.addFreshEntity((Entity)drone);
        drone.setRequest(request);
        this.roboBeeInventory.getStackInSlot(0).shrink(1);
    }

    public static void setOpen(BeePortBlockEntity entity, boolean open) {
        if (entity == null || entity.level == null) {
            return;
        }
        entity.level.setBlockAndUpdate(entity.getBlockPos(), (BlockState)entity.getBlockState().setValue((Property)BeePortBlock.IS_OPEN_TEXTURE, (Comparable)Boolean.valueOf(open)));
        entity.level.playSound(null, entity.getBlockPos(), open ? SoundEvents.BARREL_OPEN : SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS);
    }

    public boolean addItemStack(ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).isEmpty()) continue;
            this.inventory.insertItem(i, itemStack, false);
            return true;
        }
        return false;
    }

    public static boolean isPlayerInventoryFull(Player player) {
        return player.getInventory().items.stream().limit(player.getInventory().getContainerSize() - 5).noneMatch(ItemStack::isEmpty);
    }

    public static boolean sendPackageToPlayer(Player player, ItemStack itemStack) {
        if (player == null || itemStack.isEmpty()) {
            return false;
        }
        player.displayClientMessage((Component)Component.translatableWithFallback((String)"create_mobile_packages.drone_port.send_items", (String)"Send Items to Player"), true);
        if (BeePortBlockEntity.isPlayerInventoryFull(player)) {
            return false;
        }
        player.getInventory().add(itemStack);
        return true;
    }

    protected void onOpenChange(boolean open) {
        if (this.level == null) {
            return;
        }
        this.level.playSound(null, this.worldPosition, open ? SoundEvents.BARREL_OPEN : SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS);
        BeePortBlockEntity.setOpen(this, open);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DronePortTracker tracker = DronePortTracker.get(serverLevel);
            tracker.add(this);
        }
    }

    public void remove() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DronePortTracker tracker = DronePortTracker.get(serverLevel);
            tracker.remove(this);
            if (this.entityOnTravel != null) {
                this.entityOnTravel.setTargetVelocity(Vec3.ZERO);
                this.entityOnTravel.setState(new AdjustRotationToTarget());
            }
            if (this.roboBeeInventory.getStackInSlot(0).getCount() > 0) {
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), this.roboBeeInventory.getStackInSlot(0)));
            }
        }
        super.remove();
    }

    public boolean hasFullInventory(int slotsToLeaveEmpty) {
        int emptySlots = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).isEmpty()) continue;
            ++emptySlots;
        }
        return emptySlots <= slotsToLeaveEmpty;
    }

    public boolean hasFullRoboSlot(int leaveEmpty) {
        ItemStack stack = this.roboBeeInventory.getStackInSlot(0);
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getCount() >= stack.getMaxStackSize() - leaveEmpty;
    }

    public boolean isFull() {
        return this.isFull(0);
    }

    public boolean isFull(int slotsToLeaveEmpty) {
        return this.hasFullInventory(slotsToLeaveEmpty) || this.hasFullRoboSlot(0);
    }

    public boolean canAcceptEntity(RoboEntity entity, Boolean hasPackage) {
        if (this.isRemoved()) {
            return false;
        }
        if (entity == null) {
            return hasPackage.booleanValue() ? !this.isFull() : !this.hasFullRoboSlot(0);
        }
        if (this.entityOnTravel != null && this.entityOnTravel != entity) {
            return false;
        }
        return hasPackage.booleanValue() ? !this.isFull() : !this.hasFullRoboSlot(0);
    }

    public synchronized boolean trySetEntityOnTravel(RoboEntity entity) {
        if (this.entityOnTravel == null) {
            this.entityOnTravel = entity;
            return true;
        }
        return false;
    }

    public synchronized void releaseEntityOnTravel(RoboEntity entity) {
        if (this.entityOnTravel == entity) {
            CreateMobilePackages.LOGGER.info("Releasing entity on travel: {}", (Object)entity);
            this.entityOnTravel = null;
        }
    }

    public ItemStackHandler getRoboBeeInventory() {
        return this.roboBeeInventory;
    }

    public void addBeeToRoboBeeInventory(int amount) {
        this.roboBeeInventory.insertItem(0, new ItemStack((ItemLike)CMPItems.ROBO_BEE.get(), amount), false);
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return BeePortMenu.create(pContainerId, pPlayerInventory, this);
    }

    public RoboEntity getRoboEntity() {
        return this.entityOnTravel;
    }

    public ContainerData getData() {
        return this.data;
    }
}

