/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages;

import de.theidler.create_mobile_packages.RoboManagerSavedData;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class RoboManager {
    public Map<UUID, RoboEntity> robos;
    public Map<UUID, RoboEntity> clientRobos;
    public List<RoboEntity> robosToAdd;
    private RoboManagerSavedData savedData;
    private Level level;

    public RoboManager() {
        this.cleanUp();
    }

    public void markDirty() {
        if (this.savedData != null) {
            this.savedData.setDirty();
        }
    }

    public void tick(Level level) {
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        this.tickRobos(level);
    }

    private void tickRobos(Level level) {
        this.addPendingRobos();
        this.tickExistingRobos(level);
        this.removeMarkedRobos();
    }

    private void addPendingRobos() {
        if (this.robosToAdd.isEmpty()) {
            return;
        }
        ArrayList<RoboEntity> newRobos = new ArrayList<RoboEntity>(this.robosToAdd);
        for (RoboEntity robo : newRobos) {
            if (robo.level().isClientSide()) {
                this.clientRobos.put(robo.getUUID(), robo);
                continue;
            }
            this.robos.put(robo.getUUID(), robo);
        }
        this.robosToAdd.removeAll(newRobos);
    }

    private void tickExistingRobos(Level level) {
        if (this.robos.isEmpty() && this.clientRobos.isEmpty()) {
            return;
        }
        this.robos.values().stream().filter(Objects::nonNull).forEach(robo -> {
            level.guardEntityTick(entity -> {}, (Entity)robo);
            robo.roboMangerTick();
        });
        this.clientRobos.values().stream().filter(Objects::nonNull).forEach(robo -> {
            level.guardEntityTick(entity -> {}, (Entity)robo);
            robo.roboMangerTick();
        });
    }

    private void removeMarkedRobos() {
        if (this.robos.isEmpty() && this.clientRobos.isEmpty()) {
            return;
        }
        this.robos.entrySet().removeIf(entry -> ((RoboEntity)((Object)((Object)entry.getValue()))).isRemoved());
        this.clientRobos.entrySet().removeIf(entry -> ((RoboEntity)((Object)((Object)entry.getValue()))).isRemoved());
    }

    public void addRobo(RoboEntity robo) {
        this.robosToAdd.add(robo);
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void levelLoaded(LevelAccessor level) {
        this.level = (Level)level;
        MinecraftServer server = level.getServer();
        if (server == null || server.overworld() != level) {
            return;
        }
        this.cleanUp();
        this.savedData = null;
        this.loadRoboData(server);
    }

    private void loadRoboData(MinecraftServer server) {
        if (this.savedData != null) {
            return;
        }
        this.savedData = RoboManagerSavedData.load(server);
        this.robos = this.savedData.getRobos();
    }

    private void cleanUp() {
        this.robos = new ConcurrentHashMap<UUID, RoboEntity>();
        this.robosToAdd = new ArrayList<RoboEntity>();
        this.clientRobos = new ConcurrentHashMap<UUID, RoboEntity>();
    }
}

