/*
 * Decompiled with CFR 0.152.
 */
package auroras;

import auroras.util.AHelpers;
import auroras.util.AuroraData;
import auroras.util.AuroraRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;

public class ClientEventHandler {
    public static final AuroraRenderer AURORA = new AuroraRenderer();

    public static void init(ModContainer mod, IEventBus modBus) {
        IEventBus bus = NeoForge.EVENT_BUS;
        modBus.addListener(EventPriority.HIGHEST, ClientEventHandler::registerKeyBindings);
        bus.addListener(EventPriority.HIGHEST, ClientEventHandler::onKeyEvent);
        bus.addListener(EventPriority.HIGHEST, ClientEventHandler::onWorldLoad);
        bus.addListener(EventPriority.HIGHEST, ClientEventHandler::updateAurora);
    }

    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(AHelpers.RELOAD_AURORA_CONFIGS);
    }

    public static void onKeyEvent(InputEvent.Key event) {
        if (AHelpers.RELOAD_AURORA_CONFIGS.isDown()) {
            AuroraData.createConfigs();
            AuroraData.updateConfigs();
        }
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        AuroraData.createConfigs();
        AuroraData.updateConfigs();
    }

    public static void updateAurora(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        LocalPlayer viewer = mc.player;
        if (viewer != null && mc.level != null && !AuroraData.DATA_CACHE.isEmpty()) {
            for (AuroraData data : AuroraData.getDataList((Level)mc.level)) {
                if (data == null) continue;
                for (String dimension : data.allowedDimensions) {
                    if (!dimension.equals(mc.level.dimension().location().toString())) continue;
                    AURORA.update((Entity)viewer, data);
                }
            }
        }
    }
}

