/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.entity;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.client.GatewayTickableSound;
import dev.shadowsoffire.gateways.client.ParticleHandler;
import dev.shadowsoffire.gateways.event.GateEvent;
import dev.shadowsoffire.gateways.gate.GateRules;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.gate.SpawnAlgorithms;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.payloads.ParticlePayload;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class GatewayEntity
extends Entity
implements IEntityWithComplexSpawn {
    public static final EntityDataAccessor<Boolean> WAVE_ACTIVE = SynchedEntityData.defineId(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> TICKS_ACTIVE = SynchedEntityData.defineId(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> WAVE = SynchedEntityData.defineId(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> ENEMIES = SynchedEntityData.defineId(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected final Set<LivingEntity> currentWaveEntities = new HashSet<LivingEntity>();
    protected final Set<UUID> unresolvedWaveEntities = new HashSet<UUID>();
    protected UUID summonerId;
    protected DynamicHolder<Gateway> gate;
    protected float clientScale = 0.0f;
    protected Queue<ItemStack> undroppedItems = new ArrayDeque<ItemStack>();
    protected FailureReason failureReason;
    @Nullable
    protected ServerBossEvent bossEvent;

    public GatewayEntity(EntityType<? extends GatewayEntity> type, Level level, Player placer, DynamicHolder<Gateway> gate) {
        super(type, level);
        this.summonerId = placer.getUUID();
        this.gate = gate;
        Preconditions.checkArgument((boolean)gate.isBound(), (Object)"A gateway may not be constructed for an unbound holder.");
        this.setCustomName((Component)Component.translatable((String)gate.getId().toString().replace(':', '.')).withStyle(Style.EMPTY.withColor(((Gateway)gate.get()).color())));
        this.bossEvent = this.createBossEvent();
        this.refreshDimensions();
    }

    public GatewayEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public abstract Wave getCurrentWave();

    protected boolean canStartNextWave() {
        return this.getTicksActive() > this.getSetupTime();
    }

    public abstract boolean isCompleted();

    protected abstract void completeWave();

    public int getSetupTime() {
        return this.getCurrentWave().setupTime();
    }

    public int getMaxWaveTime() {
        return this.getCurrentWave().maxWaveTime();
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        if (!this.gate.isBound()) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        super.tick();
        if (!this.level().isClientSide) {
            if (!this.unresolvedWaveEntities.isEmpty()) {
                for (UUID uUID : this.unresolvedWaveEntities) {
                    Entity e2 = ((ServerLevel)this.level()).getEntity(uUID);
                    if (!(e2 instanceof LivingEntity)) continue;
                    this.currentWaveEntities.add((LivingEntity)e2);
                }
                this.unresolvedWaveEntities.clear();
            }
            if (this.isWaveActive()) {
                int maxWaveTime = this.getMaxWaveTime();
                if (this.getTicksActive() > maxWaveTime) {
                    this.onFailure(this.currentWaveEntities, FailureReason.TIMER_ELAPSED);
                    return;
                }
            }
            this.entityData.set(TICKS_ACTIVE, (Object)(this.getTicksActive() + 1));
            List<LivingEntity> enemies = this.currentWaveEntities.stream().filter(e -> e.getHealth() > 0.0f && !this.isValidRemoval(e.getRemovalReason())).toList();
            if (this.tickCount % 20 == 0) {
                for (LivingEntity entity : enemies) {
                    if (GatewayEntity.hasLeftDimension((Entity)entity)) {
                        this.onFailure(this.currentWaveEntities, FailureReason.ENTITY_LEFT_DIMENSION);
                        return;
                    }
                    if (entity.getRemovalReason() == Entity.RemovalReason.DISCARDED) {
                        this.onFailure(this.currentWaveEntities, FailureReason.ENTITY_DISCARDED);
                        return;
                    }
                    if (entity.tickCount > 30) {
                        this.spawnParticle(entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), ParticlePayload.EffectType.IDLE);
                    }
                    if (!this.isOutOfRange((Entity)entity) || !this.getGateway().rules().failOnOutOfBounds() && this.respawnEntity((Entity)entity)) continue;
                    this.onFailure(this.currentWaveEntities, FailureReason.ENTITY_TOO_FAR);
                    return;
                }
            }
            this.entityData.set(ENEMIES, (Object)enemies.size());
            if (this.tickCount % 4 == 0 && !this.undroppedItems.isEmpty()) {
                void var2_7;
                boolean bl = false;
                while (var2_7 < this.getDropCount()) {
                    this.spawnItem(this.undroppedItems.remove());
                    if (this.undroppedItems.isEmpty()) break;
                    ++var2_7;
                }
            }
            if (this.isWaveActive()) {
                if (enemies.isEmpty()) {
                    this.completeWave();
                    NeoForge.EVENT_BUS.post((Event)new GateEvent.WaveEnd(this));
                    this.currentWaveEntities.clear();
                    this.entityData.set(WAVE_ACTIVE, (Object)false);
                    this.entityData.set(TICKS_ACTIVE, (Object)0);
                    this.entityData.set(WAVE, (Object)(this.getWave() + 1));
                }
            } else {
                if (this.canStartNextWave()) {
                    this.startNextWave();
                    this.entityData.set(WAVE_ACTIVE, (Object)true);
                    this.entityData.set(TICKS_ACTIVE, (Object)0);
                    this.entityData.set(ENEMIES, (Object)this.currentWaveEntities.size());
                    NeoForge.EVENT_BUS.post((Event)new GateEvent.WaveStarted(this));
                    return;
                }
                if (this.isCompleted()) {
                    this.completeGateway();
                }
            }
        } else if (this.tickCount % 30 == 0) {
            ParticleHandler.spawnIdleParticles(this);
        }
    }

    public EntityDimensions getDimensions(Pose pPose) {
        return ((Gateway)this.gate.get()).size().getDims();
    }

    protected boolean isValidRemoval(@Nullable Entity.RemovalReason reason) {
        GateRules rules = this.getGateway().rules();
        return reason == Entity.RemovalReason.KILLED || rules.allowDiscarding() && reason == Entity.RemovalReason.DISCARDED || rules.allowDimChange() && reason == Entity.RemovalReason.CHANGED_DIMENSION;
    }

    protected int getDropCount() {
        return 3 + this.undroppedItems.size() / 100;
    }

    protected void startNextWave() {
        List<LivingEntity> spawned = this.getCurrentWave().spawnWave((ServerLevel)this.level(), this.position(), this);
        this.currentWaveEntities.addAll(spawned);
    }

    protected void completeGateway() {
        this.remove(Entity.RemovalReason.KILLED);
        this.playSound((SoundEvent)GatewayObjects.GATE_END.value(), 16.0f, 1.0f);
        this.level().getNearbyPlayers(TargetingConditions.DEFAULT, null, this.getBoundingBox().inflate(15.0)).forEach(p -> p.awardStat(GatewayObjects.GATES_DEFEATED));
        NeoForge.EVENT_BUS.post((Event)new GateEvent.Completed(this));
    }

    public void onGateCreated() {
        this.playSound((SoundEvent)GatewayObjects.GATE_START.value(), 1.0f, 1.0f);
        NeoForge.EVENT_BUS.post((Event)new GateEvent.Opened(this));
    }

    public Player summonerOrClosest() {
        Player player;
        Player player2 = player = this.summonerId == null ? null : this.level().getPlayerByUUID(this.summonerId);
        if (player == null) {
            player = this.level().getNearestPlayer((Entity)this, 50.0);
        }
        if (player == null) {
            return this.summonerId == null ? FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.level())) : FakePlayerFactory.get((ServerLevel)((ServerLevel)this.level()), (GameProfile)new GameProfile(this.summonerId, ""));
        }
        return player;
    }

    public void onFailure(Collection<LivingEntity> remaining, FailureReason reason) {
        this.failureReason = reason;
        NeoForge.EVENT_BUS.post((Event)new GateEvent.Failed(this));
        Player player = this.summonerOrClosest();
        if (player != null) {
            player.sendSystemMessage(reason.getMsg());
        }
        GatewayEntity.spawnLightningOn(this, false);
        remaining.stream().filter(Entity::isAlive).forEach(e -> {
            if (this.getGateway().rules().removeOnFailure()) {
                GatewayEntity.spawnLightningOn((Entity)e, true);
                e.remove(Entity.RemovalReason.DISCARDED);
            } else if (e instanceof Mob) {
                Mob mob = (Mob)e;
                mob.persistenceRequired = false;
            }
        });
        this.getGateway().failures().forEach(f -> f.onFailure((ServerLevel)this.level(), this, player, reason));
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected ServerBossEvent createBossEvent() {
        if (this.getGateway().bossSettings().drawAsBar()) {
            ServerBossEvent event = new ServerBossEvent((Component)Component.literal((String)("GATEWAY_ID" + this.getId())), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
            event.setCreateWorldFog(this.getGateway().bossSettings().fog());
            return event;
        }
        return null;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("wave", this.getWave());
        tag.putString("gate", this.gate.getId().toString());
        long[] ids = new long[this.currentWaveEntities.size() * 2];
        int idx = 0;
        for (LivingEntity e : this.currentWaveEntities) {
            UUID id = e.getUUID();
            ids[idx++] = id.getMostSignificantBits();
            ids[idx++] = id.getLeastSignificantBits();
        }
        tag.putLongArray("wave_entities", ids);
        tag.putBoolean("active", this.isWaveActive());
        tag.putInt("ticks_active", this.getTicksActive());
        if (this.summonerId != null) {
            tag.putUUID("summoner", this.summonerId);
        }
        ListTag stacks = new ListTag();
        for (ItemStack s : this.undroppedItems) {
            stacks.add((Object)s.save((HolderLookup.Provider)this.registryAccess()));
        }
        tag.put("queued_stacks", (Tag)stacks);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("wave")) {
            this.entityData.set(WAVE, (Object)tag.getInt("wave"));
        }
        if (tag.contains("gate")) {
            this.gate = GatewayRegistry.INSTANCE.holder(ResourceLocation.tryParse((String)tag.getString("gate")));
        }
        if (!this.gate.isBound()) {
            Gateways.LOGGER.error("Invalid gateway at {} will be removed.", (Object)this.position());
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (tag.contains("wave_entities")) {
            this.currentWaveEntities.clear();
            this.unresolvedWaveEntities.clear();
            long[] entities = tag.getLongArray("wave_entities");
            for (int i = 0; i < entities.length; i += 2) {
                this.unresolvedWaveEntities.add(new UUID(entities[i], entities[i + 1]));
            }
        }
        if (tag.contains("active")) {
            this.entityData.set(WAVE_ACTIVE, (Object)tag.getBoolean("active"));
        }
        if (tag.contains("ticks_active")) {
            this.entityData.set(TICKS_ACTIVE, (Object)tag.getInt("ticks_active"));
        }
        if (tag.contains("summoner")) {
            this.summonerId = tag.getUUID("summoner");
        }
        if (tag.contains("queued_stacks")) {
            this.undroppedItems.clear();
            ListTag stacks = tag.getList("queued_stacks", 10);
            for (Tag inbt : stacks) {
                ItemStack stack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)((CompoundTag)inbt)).orElse(ItemStack.EMPTY);
                if (stack.isEmpty()) continue;
                this.undroppedItems.add(stack);
            }
        }
        this.bossEvent = this.createBossEvent();
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(WAVE_ACTIVE, (Object)false);
        builder.define(TICKS_ACTIVE, (Object)0);
        builder.define(WAVE, (Object)0);
        builder.define(ENEMIES, (Object)0);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        if (this.bossEvent != null) {
            this.bossEvent.addPlayer(player);
        }
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        if (this.bossEvent != null) {
            this.bossEvent.removePlayer(player);
        }
    }

    public int getTicksActive() {
        return (Integer)this.entityData.get(TICKS_ACTIVE);
    }

    public boolean isWaveActive() {
        return (Boolean)this.entityData.get(WAVE_ACTIVE);
    }

    public int getWave() {
        return (Integer)this.entityData.get(WAVE);
    }

    public int getActiveEnemies() {
        return (Integer)this.entityData.get(ENEMIES);
    }

    public Gateway getGateway() {
        return (Gateway)this.gate.get();
    }

    public boolean isValid() {
        return this.gate.isBound();
    }

    @Nullable
    public ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    public float getClientScale() {
        return this.clientScale;
    }

    public void setClientScale(float clientScale) {
        this.clientScale = clientScale;
    }

    public void spawnParticle(double x, double y, double z, ParticlePayload.EffectType type) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level()), (ChunkPos)this.chunkPosition(), (CustomPacketPayload)new ParticlePayload(this, x, y, z, this.getGateway().color(), type), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void spawnItem(ItemStack stack) {
        ItemEntity i = new ItemEntity(this.level(), 0.0, 0.0, 0.0, stack);
        i.setPos(this.getX() + Mth.nextDouble((RandomSource)this.random, (double)-0.5, (double)0.5), this.getY() + 1.5, this.getZ() + Mth.nextDouble((RandomSource)this.random, (double)-0.5, (double)0.5));
        i.setDeltaMovement(Mth.nextDouble((RandomSource)this.random, (double)-0.15, (double)0.15), 0.4, Mth.nextDouble((RandomSource)this.random, (double)-0.15, (double)0.15));
        this.level().addFreshEntity((Entity)i);
        this.level().playSound(null, i.getX(), i.getY(), i.getZ(), GatewayObjects.GATE_WARP, SoundSource.HOSTILE, 0.25f, 2.0f);
    }

    public void spawnCompletionItem(ItemStack stack) {
        ItemEntity i = new ItemEntity(this.level(), 0.0, 0.0, 0.0, stack);
        double variance = 0.05f * this.getGateway().size().getScale();
        i.setPos(this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ());
        i.setDeltaMovement(Mth.nextDouble((RandomSource)this.random, (double)(-variance), (double)variance), (double)(this.getBbHeight() / 20.0f), Mth.nextDouble((RandomSource)this.random, (double)(-variance), (double)variance));
        i.setUnlimitedLifetime();
        this.level().addFreshEntity((Entity)i);
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.gate.getId());
    }

    public void readSpawnData(RegistryFriendlyByteBuf buf) {
        this.gate = GatewayRegistry.INSTANCE.holder(buf.readResourceLocation());
        if (!this.gate.isBound()) {
            throw new RuntimeException("Invalid gateway received on client!");
        }
        this.refreshDimensions();
        GatewayTickableSound.startGatewaySound(this);
    }

    protected int getPermissionLevel() {
        return 2;
    }

    @Nullable
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public boolean isOutOfRange(Entity entity) {
        return entity.distanceToSqr((Entity)this) > this.getGateway().getLeashRangeSq();
    }

    public void handleConversion(Entity entity, LivingEntity outcome) {
        entity.getPersistentData().remove("gateways.owner");
        outcome.getPersistentData().putUUID("gateways.owner", this.getUUID());
        if (this.unresolvedWaveEntities.contains(entity.getUUID())) {
            this.unresolvedWaveEntities.remove(entity.getUUID());
            this.unresolvedWaveEntities.add(outcome.getUUID());
        } else if (this.currentWaveEntities.contains(entity)) {
            this.currentWaveEntities.remove(entity);
            this.currentWaveEntities.add(outcome);
        }
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean respawnEntity(Entity entity) {
        SpawnAlgorithms.SpawnAlgorithm algo = this.getGateway().spawnAlgo();
        Vec3 pos = algo.spawn((ServerLevel)this.level(), this.position(), this, entity);
        if (pos == null) {
            return false;
        }
        entity.resetFallDistance();
        this.spawnParticle(entity.getX(), entity.getY(), entity.getZ(), ParticlePayload.EffectType.SPAWNED);
        entity.setPos(pos);
        this.spawnParticle(entity.getX(), entity.getY(), entity.getZ(), ParticlePayload.EffectType.SPAWNED);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            Player p = this.summonerOrClosest();
            if (!(p instanceof FakePlayer)) {
                mob.setTarget((LivingEntity)p);
            }
        }
        return true;
    }

    public static void spawnLightningOn(Entity entity, boolean effectOnly) {
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(entity.level());
        bolt.setPos(entity.getX(), entity.getY(), entity.getZ());
        bolt.setVisualOnly(effectOnly);
        entity.level().addFreshEntity((Entity)bolt);
    }

    public static boolean hasLeftDimension(Entity entity) {
        return entity.getRemovalReason() == Entity.RemovalReason.CHANGED_DIMENSION;
    }

    @Nullable
    public static GatewayEntity getOwner(Entity entity) {
        if (entity.getPersistentData().contains("gateways.owner")) {
            GatewayEntity gate;
            ServerLevel sl;
            UUID id = entity.getPersistentData().getUUID("gateways.owner");
            Level level = entity.level();
            if (level instanceof ServerLevel && (level = (sl = (ServerLevel)level).getEntity(id)) instanceof GatewayEntity && (gate = (GatewayEntity)level).isValid()) {
                return gate;
            }
        }
        return null;
    }

    public static enum FailureReason {
        SPAWN_FAILED("error.gateways.wave_failed"),
        ENTITY_TOO_FAR("error.gateways.too_far"),
        TIMER_ELAPSED("error.gateways.wave_elapsed"),
        ENTITY_DISCARDED("error.gateways.entity_discarded"),
        ENTITY_LEFT_DIMENSION("error.gateways.left_dimension");

        private final String langKey;

        private FailureReason(String langKey) {
            this.langKey = langKey;
        }

        public Component getMsg() {
            return Component.translatable((String)this.langKey).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE});
        }
    }
}

