/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.init;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.extensions.IDataComponentHolderExtension;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageIOBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageIOBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageInputBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageLinkBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageLinkBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageOutputBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.DecorationTableMenu;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.LimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.LimitedBarrelSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.crafting.BarrelMaterialRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.BaseTierWoodenStorageIngredient;
import net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.FlatTopBarrelToggleRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.GenericWoodStorageRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromChestRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromVanillaShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageDyeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocksClient;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class ModBlocks {
    private static final String LIMITED_BARREL_NAME = "limited_barrel";
    public static final TagKey<Item> BASE_TIER_WOODEN_STORAGE_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SophisticatedStorage.getRL("base_tier_wooden_storage"));
    public static final TagKey<Item> ALL_STORAGE_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SophisticatedStorage.getRL("all_storage"));
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"sophisticatedstorage");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"sophisticatedstorage");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"sophisticatedstorage");
    private static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"sophisticatedstorage");
    private static final String BARREL_REG_NAME = "barrel";
    public static final Supplier<BarrelBlock> BARREL = BLOCKS.register("barrel", () -> new BarrelBlock((Supplier<Integer>)Config.SERVER.woodBarrel.inventorySlotCount, (Supplier<Integer>)Config.SERVER.woodBarrel.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> COPPER_BARREL = BLOCKS.register("copper_barrel", () -> new BarrelBlock((Supplier<Integer>)Config.SERVER.copperBarrel.inventorySlotCount, (Supplier<Integer>)Config.SERVER.copperBarrel.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> IRON_BARREL = BLOCKS.register("iron_barrel", () -> new BarrelBlock((Supplier<Integer>)Config.SERVER.ironBarrel.inventorySlotCount, (Supplier<Integer>)Config.SERVER.ironBarrel.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> GOLD_BARREL = BLOCKS.register("gold_barrel", () -> new BarrelBlock((Supplier<Integer>)Config.SERVER.goldBarrel.inventorySlotCount, (Supplier<Integer>)Config.SERVER.goldBarrel.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> DIAMOND_BARREL = BLOCKS.register("diamond_barrel", () -> new BarrelBlock((Supplier<Integer>)Config.SERVER.diamondBarrel.inventorySlotCount, (Supplier<Integer>)Config.SERVER.diamondBarrel.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> NETHERITE_BARREL = BLOCKS.register("netherite_barrel", () -> new BarrelBlock((Supplier<Integer>)Config.SERVER.netheriteBarrel.inventorySlotCount, (Supplier<Integer>)Config.SERVER.netheriteBarrel.upgradeSlotCount, 1200.0f));
    public static final Supplier<BlockItem> BARREL_ITEM = ITEMS.register("barrel", () -> new BarrelBlockItem((Block)BARREL.get()));
    public static final Supplier<BlockItem> COPPER_BARREL_ITEM = ITEMS.register("copper_barrel", () -> new BarrelBlockItem((Block)COPPER_BARREL.get()));
    public static final Supplier<BlockItem> IRON_BARREL_ITEM = ITEMS.register("iron_barrel", () -> new BarrelBlockItem((Block)IRON_BARREL.get()));
    public static final Supplier<BlockItem> GOLD_BARREL_ITEM = ITEMS.register("gold_barrel", () -> new BarrelBlockItem((Block)GOLD_BARREL.get()));
    public static final Supplier<BlockItem> DIAMOND_BARREL_ITEM = ITEMS.register("diamond_barrel", () -> new BarrelBlockItem((Block)DIAMOND_BARREL.get()));
    public static final Supplier<BlockItem> NETHERITE_BARREL_ITEM = ITEMS.register("netherite_barrel", () -> new BarrelBlockItem((Block)NETHERITE_BARREL.get(), new Item.Properties().fireResistant()));
    private static final String LIMITED_BARREL_REG_NAME = "limited_barrel";
    public static final Supplier<BarrelBlock> LIMITED_BARREL_1 = BLOCKS.register("limited_barrel_1", () -> new LimitedBarrelBlock(1, (Supplier<Integer>)Config.SERVER.limitedBarrel1.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.limitedBarrel1.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_COPPER_BARREL_1 = BLOCKS.register("limited_copper_barrel_1", () -> new LimitedBarrelBlock(1, (Supplier<Integer>)Config.SERVER.copperLimitedBarrel1.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.copperLimitedBarrel1.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_IRON_BARREL_1 = BLOCKS.register("limited_iron_barrel_1", () -> new LimitedBarrelBlock(1, (Supplier<Integer>)Config.SERVER.ironLimitedBarrel1.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.ironLimitedBarrel1.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_GOLD_BARREL_1 = BLOCKS.register("limited_gold_barrel_1", () -> new LimitedBarrelBlock(1, (Supplier<Integer>)Config.SERVER.goldLimitedBarrel1.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.goldLimitedBarrel1.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_DIAMOND_BARREL_1 = BLOCKS.register("limited_diamond_barrel_1", () -> new LimitedBarrelBlock(1, (Supplier<Integer>)Config.SERVER.diamondLimitedBarrel1.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.diamondLimitedBarrel1.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_NETHERITE_BARREL_1 = BLOCKS.register("limited_netherite_barrel_1", () -> new LimitedBarrelBlock(1, (Supplier<Integer>)Config.SERVER.netheriteLimitedBarrel1.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.netheriteLimitedBarrel1.upgradeSlotCount, 1200.0f));
    public static final Supplier<BlockItem> LIMITED_BARREL_1_ITEM = ITEMS.register("limited_barrel_1", () -> new BarrelBlockItem((Block)LIMITED_BARREL_1.get()));
    public static final Supplier<BlockItem> LIMITED_IRON_BARREL_1_ITEM = ITEMS.register("limited_iron_barrel_1", () -> new BarrelBlockItem((Block)LIMITED_IRON_BARREL_1.get()));
    public static final Supplier<BlockItem> LIMITED_COPPER_BARREL_1_ITEM = ITEMS.register("limited_copper_barrel_1", () -> new BarrelBlockItem((Block)LIMITED_COPPER_BARREL_1.get()));
    public static final Supplier<BlockItem> LIMITED_GOLD_BARREL_1_ITEM = ITEMS.register("limited_gold_barrel_1", () -> new BarrelBlockItem((Block)LIMITED_GOLD_BARREL_1.get()));
    public static final Supplier<BlockItem> LIMITED_DIAMOND_BARREL_1_ITEM = ITEMS.register("limited_diamond_barrel_1", () -> new BarrelBlockItem((Block)LIMITED_DIAMOND_BARREL_1.get()));
    public static final Supplier<BlockItem> LIMITED_NETHERITE_BARREL_1_ITEM = ITEMS.register("limited_netherite_barrel_1", () -> new BarrelBlockItem((Block)LIMITED_NETHERITE_BARREL_1.get(), new Item.Properties().fireResistant()));
    public static final Supplier<BarrelBlock> LIMITED_BARREL_2 = BLOCKS.register("limited_barrel_2", () -> new LimitedBarrelBlock(2, (Supplier<Integer>)Config.SERVER.limitedBarrel2.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.limitedBarrel2.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_COPPER_BARREL_2 = BLOCKS.register("limited_copper_barrel_2", () -> new LimitedBarrelBlock(2, (Supplier<Integer>)Config.SERVER.copperLimitedBarrel2.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.copperLimitedBarrel2.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_IRON_BARREL_2 = BLOCKS.register("limited_iron_barrel_2", () -> new LimitedBarrelBlock(2, (Supplier<Integer>)Config.SERVER.ironLimitedBarrel2.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.ironLimitedBarrel2.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_GOLD_BARREL_2 = BLOCKS.register("limited_gold_barrel_2", () -> new LimitedBarrelBlock(2, (Supplier<Integer>)Config.SERVER.goldLimitedBarrel2.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.goldLimitedBarrel2.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_DIAMOND_BARREL_2 = BLOCKS.register("limited_diamond_barrel_2", () -> new LimitedBarrelBlock(2, (Supplier<Integer>)Config.SERVER.diamondLimitedBarrel2.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.diamondLimitedBarrel2.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_NETHERITE_BARREL_2 = BLOCKS.register("limited_netherite_barrel_2", () -> new LimitedBarrelBlock(2, (Supplier<Integer>)Config.SERVER.netheriteLimitedBarrel2.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.netheriteLimitedBarrel2.upgradeSlotCount, 1200.0f));
    public static final Supplier<BlockItem> LIMITED_BARREL_2_ITEM = ITEMS.register("limited_barrel_2", () -> new BarrelBlockItem((Block)LIMITED_BARREL_2.get()));
    public static final Supplier<BlockItem> LIMITED_COPPER_BARREL_2_ITEM = ITEMS.register("limited_copper_barrel_2", () -> new BarrelBlockItem((Block)LIMITED_COPPER_BARREL_2.get()));
    public static final Supplier<BlockItem> LIMITED_IRON_BARREL_2_ITEM = ITEMS.register("limited_iron_barrel_2", () -> new BarrelBlockItem((Block)LIMITED_IRON_BARREL_2.get()));
    public static final Supplier<BlockItem> LIMITED_GOLD_BARREL_2_ITEM = ITEMS.register("limited_gold_barrel_2", () -> new BarrelBlockItem((Block)LIMITED_GOLD_BARREL_2.get()));
    public static final Supplier<BlockItem> LIMITED_DIAMOND_BARREL_2_ITEM = ITEMS.register("limited_diamond_barrel_2", () -> new BarrelBlockItem((Block)LIMITED_DIAMOND_BARREL_2.get()));
    public static final Supplier<BlockItem> LIMITED_NETHERITE_BARREL_2_ITEM = ITEMS.register("limited_netherite_barrel_2", () -> new BarrelBlockItem((Block)LIMITED_NETHERITE_BARREL_2.get(), new Item.Properties().fireResistant()));
    public static final Supplier<BarrelBlock> LIMITED_BARREL_3 = BLOCKS.register("limited_barrel_3", () -> new LimitedBarrelBlock(3, (Supplier<Integer>)Config.SERVER.limitedBarrel3.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.limitedBarrel3.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_COPPER_BARREL_3 = BLOCKS.register("limited_copper_barrel_3", () -> new LimitedBarrelBlock(3, (Supplier<Integer>)Config.SERVER.copperLimitedBarrel3.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.copperLimitedBarrel3.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_IRON_BARREL_3 = BLOCKS.register("limited_iron_barrel_3", () -> new LimitedBarrelBlock(3, (Supplier<Integer>)Config.SERVER.ironLimitedBarrel3.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.ironLimitedBarrel3.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_GOLD_BARREL_3 = BLOCKS.register("limited_gold_barrel_3", () -> new LimitedBarrelBlock(3, (Supplier<Integer>)Config.SERVER.goldLimitedBarrel3.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.goldLimitedBarrel3.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_DIAMOND_BARREL_3 = BLOCKS.register("limited_diamond_barrel_3", () -> new LimitedBarrelBlock(3, (Supplier<Integer>)Config.SERVER.diamondLimitedBarrel3.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.diamondLimitedBarrel3.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_NETHERITE_BARREL_3 = BLOCKS.register("limited_netherite_barrel_3", () -> new LimitedBarrelBlock(3, (Supplier<Integer>)Config.SERVER.netheriteLimitedBarrel3.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.netheriteLimitedBarrel3.upgradeSlotCount, 1200.0f));
    public static final Supplier<BlockItem> LIMITED_BARREL_3_ITEM = ITEMS.register("limited_barrel_3", () -> new BarrelBlockItem((Block)LIMITED_BARREL_3.get()));
    public static final Supplier<BlockItem> LIMITED_COPPER_BARREL_3_ITEM = ITEMS.register("limited_copper_barrel_3", () -> new BarrelBlockItem((Block)LIMITED_COPPER_BARREL_3.get()));
    public static final Supplier<BlockItem> LIMITED_IRON_BARREL_3_ITEM = ITEMS.register("limited_iron_barrel_3", () -> new BarrelBlockItem((Block)LIMITED_IRON_BARREL_3.get()));
    public static final Supplier<BlockItem> LIMITED_GOLD_BARREL_3_ITEM = ITEMS.register("limited_gold_barrel_3", () -> new BarrelBlockItem((Block)LIMITED_GOLD_BARREL_3.get()));
    public static final Supplier<BlockItem> LIMITED_DIAMOND_BARREL_3_ITEM = ITEMS.register("limited_diamond_barrel_3", () -> new BarrelBlockItem((Block)LIMITED_DIAMOND_BARREL_3.get()));
    public static final Supplier<BlockItem> LIMITED_NETHERITE_BARREL_3_ITEM = ITEMS.register("limited_netherite_barrel_3", () -> new BarrelBlockItem((Block)LIMITED_NETHERITE_BARREL_3.get(), new Item.Properties().fireResistant()));
    public static final Supplier<BarrelBlock> LIMITED_BARREL_4 = BLOCKS.register("limited_barrel_4", () -> new LimitedBarrelBlock(4, (Supplier<Integer>)Config.SERVER.limitedBarrel4.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.limitedBarrel4.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_COPPER_BARREL_4 = BLOCKS.register("limited_copper_barrel_4", () -> new LimitedBarrelBlock(4, (Supplier<Integer>)Config.SERVER.copperLimitedBarrel4.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.copperLimitedBarrel4.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_IRON_BARREL_4 = BLOCKS.register("limited_iron_barrel_4", () -> new LimitedBarrelBlock(4, (Supplier<Integer>)Config.SERVER.ironLimitedBarrel4.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.ironLimitedBarrel4.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_GOLD_BARREL_4 = BLOCKS.register("limited_gold_barrel_4", () -> new LimitedBarrelBlock(4, (Supplier<Integer>)Config.SERVER.goldLimitedBarrel4.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.goldLimitedBarrel4.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_DIAMOND_BARREL_4 = BLOCKS.register("limited_diamond_barrel_4", () -> new LimitedBarrelBlock(4, (Supplier<Integer>)Config.SERVER.diamondLimitedBarrel4.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.diamondLimitedBarrel4.upgradeSlotCount, 0.0f));
    public static final Supplier<BarrelBlock> LIMITED_NETHERITE_BARREL_4 = BLOCKS.register("limited_netherite_barrel_4", () -> new LimitedBarrelBlock(4, (Supplier<Integer>)Config.SERVER.netheriteLimitedBarrel4.baseSlotLimitMultiplier, (Supplier<Integer>)Config.SERVER.netheriteLimitedBarrel4.upgradeSlotCount, 1200.0f));
    public static final Supplier<BlockItem> LIMITED_BARREL_4_ITEM = ITEMS.register("limited_barrel_4", () -> new BarrelBlockItem((Block)LIMITED_BARREL_4.get()));
    public static final Supplier<BlockItem> LIMITED_COPPER_BARREL_4_ITEM = ITEMS.register("limited_copper_barrel_4", () -> new BarrelBlockItem((Block)LIMITED_COPPER_BARREL_4.get()));
    public static final Supplier<BlockItem> LIMITED_IRON_BARREL_4_ITEM = ITEMS.register("limited_iron_barrel_4", () -> new BarrelBlockItem((Block)LIMITED_IRON_BARREL_4.get()));
    public static final Supplier<BlockItem> LIMITED_GOLD_BARREL_4_ITEM = ITEMS.register("limited_gold_barrel_4", () -> new BarrelBlockItem((Block)LIMITED_GOLD_BARREL_4.get()));
    public static final Supplier<BlockItem> LIMITED_DIAMOND_BARREL_4_ITEM = ITEMS.register("limited_diamond_barrel_4", () -> new BarrelBlockItem((Block)LIMITED_DIAMOND_BARREL_4.get()));
    public static final Supplier<BlockItem> LIMITED_NETHERITE_BARREL_4_ITEM = ITEMS.register("limited_netherite_barrel_4", () -> new BarrelBlockItem((Block)LIMITED_NETHERITE_BARREL_4.get(), new Item.Properties().fireResistant()));
    private static final String CHEST_REG_NAME = "chest";
    public static final Supplier<ChestBlock> CHEST = BLOCKS.register("chest", () -> new ChestBlock((Supplier<Integer>)Config.SERVER.woodChest.inventorySlotCount, (Supplier<Integer>)Config.SERVER.woodChest.upgradeSlotCount));
    public static final Supplier<ChestBlock> COPPER_CHEST = BLOCKS.register("copper_chest", () -> new ChestBlock((Supplier<Integer>)Config.SERVER.copperChest.inventorySlotCount, (Supplier<Integer>)Config.SERVER.copperChest.upgradeSlotCount));
    public static final Supplier<ChestBlock> IRON_CHEST = BLOCKS.register("iron_chest", () -> new ChestBlock((Supplier<Integer>)Config.SERVER.ironChest.inventorySlotCount, (Supplier<Integer>)Config.SERVER.ironChest.upgradeSlotCount));
    public static final Supplier<ChestBlock> GOLD_CHEST = BLOCKS.register("gold_chest", () -> new ChestBlock((Supplier<Integer>)Config.SERVER.goldChest.inventorySlotCount, (Supplier<Integer>)Config.SERVER.goldChest.upgradeSlotCount));
    public static final Supplier<ChestBlock> DIAMOND_CHEST = BLOCKS.register("diamond_chest", () -> new ChestBlock((Supplier<Integer>)Config.SERVER.diamondChest.inventorySlotCount, (Supplier<Integer>)Config.SERVER.diamondChest.upgradeSlotCount));
    public static final Supplier<ChestBlock> NETHERITE_CHEST = BLOCKS.register("netherite_chest", () -> new ChestBlock((Supplier<Integer>)Config.SERVER.netheriteChest.inventorySlotCount, (Supplier<Integer>)Config.SERVER.netheriteChest.upgradeSlotCount, 1200.0f));
    public static final Supplier<BlockItem> CHEST_ITEM = ITEMS.register("chest", () -> new ChestBlockItem((Block)CHEST.get()));
    public static final Supplier<BlockItem> COPPER_CHEST_ITEM = ITEMS.register("copper_chest", () -> new ChestBlockItem((Block)COPPER_CHEST.get()));
    public static final Supplier<BlockItem> IRON_CHEST_ITEM = ITEMS.register("iron_chest", () -> new ChestBlockItem((Block)IRON_CHEST.get()));
    public static final Supplier<BlockItem> GOLD_CHEST_ITEM = ITEMS.register("gold_chest", () -> new ChestBlockItem((Block)GOLD_CHEST.get()));
    public static final Supplier<BlockItem> DIAMOND_CHEST_ITEM = ITEMS.register("diamond_chest", () -> new ChestBlockItem((Block)DIAMOND_CHEST.get()));
    public static final Supplier<BlockItem> NETHERITE_CHEST_ITEM = ITEMS.register("netherite_chest", () -> new ChestBlockItem((Block)NETHERITE_CHEST.get(), new Item.Properties().fireResistant()));
    private static final String SHULKER_BOX_REG_NAME = "shulker_box";
    public static final Supplier<ShulkerBoxBlock> SHULKER_BOX = BLOCKS.register("shulker_box", () -> new ShulkerBoxBlock((Supplier<Integer>)Config.SERVER.shulkerBox.inventorySlotCount, (Supplier<Integer>)Config.SERVER.shulkerBox.upgradeSlotCount));
    public static final Supplier<ShulkerBoxBlock> COPPER_SHULKER_BOX = BLOCKS.register("copper_shulker_box", () -> new ShulkerBoxBlock((Supplier<Integer>)Config.SERVER.copperShulkerBox.inventorySlotCount, (Supplier<Integer>)Config.SERVER.copperShulkerBox.upgradeSlotCount));
    public static final Supplier<ShulkerBoxBlock> IRON_SHULKER_BOX = BLOCKS.register("iron_shulker_box", () -> new ShulkerBoxBlock((Supplier<Integer>)Config.SERVER.ironShulkerBox.inventorySlotCount, (Supplier<Integer>)Config.SERVER.ironShulkerBox.upgradeSlotCount));
    public static final Supplier<ShulkerBoxBlock> GOLD_SHULKER_BOX = BLOCKS.register("gold_shulker_box", () -> new ShulkerBoxBlock((Supplier<Integer>)Config.SERVER.goldShulkerBox.inventorySlotCount, (Supplier<Integer>)Config.SERVER.goldShulkerBox.upgradeSlotCount));
    public static final Supplier<ShulkerBoxBlock> DIAMOND_SHULKER_BOX = BLOCKS.register("diamond_shulker_box", () -> new ShulkerBoxBlock((Supplier<Integer>)Config.SERVER.diamondShulkerBox.inventorySlotCount, (Supplier<Integer>)Config.SERVER.diamondShulkerBox.upgradeSlotCount));
    public static final Supplier<ShulkerBoxBlock> NETHERITE_SHULKER_BOX = BLOCKS.register("netherite_shulker_box", () -> new ShulkerBoxBlock((Supplier<Integer>)Config.SERVER.netheriteShulkerBox.inventorySlotCount, (Supplier<Integer>)Config.SERVER.netheriteShulkerBox.upgradeSlotCount, 1200.0f));
    public static final Supplier<BlockItem> SHULKER_BOX_ITEM = ITEMS.register("shulker_box", () -> new ShulkerBoxItem((Block)SHULKER_BOX.get()));
    public static final Supplier<BlockItem> COPPER_SHULKER_BOX_ITEM = ITEMS.register("copper_shulker_box", () -> new ShulkerBoxItem((Block)COPPER_SHULKER_BOX.get()));
    public static final Supplier<BlockItem> IRON_SHULKER_BOX_ITEM = ITEMS.register("iron_shulker_box", () -> new ShulkerBoxItem((Block)IRON_SHULKER_BOX.get()));
    public static final Supplier<BlockItem> GOLD_SHULKER_BOX_ITEM = ITEMS.register("gold_shulker_box", () -> new ShulkerBoxItem((Block)GOLD_SHULKER_BOX.get()));
    public static final Supplier<BlockItem> DIAMOND_SHULKER_BOX_ITEM = ITEMS.register("diamond_shulker_box", () -> new ShulkerBoxItem((Block)DIAMOND_SHULKER_BOX.get()));
    public static final Supplier<BlockItem> NETHERITE_SHULKER_BOX_ITEM = ITEMS.register("netherite_shulker_box", () -> new ShulkerBoxItem((Block)NETHERITE_SHULKER_BOX.get(), new Item.Properties().stacksTo(1).fireResistant()));
    private static final String CONTROLLER_REG_NAME = "controller";
    public static final Supplier<ControllerBlock> CONTROLLER = BLOCKS.register("controller", ControllerBlock::new);
    private static final String STORAGE_LINK_REG_NAME = "storage_link";
    public static final Supplier<StorageLinkBlock> STORAGE_LINK = BLOCKS.register("storage_link", StorageLinkBlock::new);
    public static final DeferredHolder<Item, BlockItem> CONTROLLER_ITEM = ITEMS.register("controller", () -> new BlockItemBase((Block)CONTROLLER.get(), new Item.Properties()));
    public static final Supplier<BlockItem> STORAGE_LINK_ITEM = ITEMS.register("storage_link", () -> new BlockItemBase((Block)STORAGE_LINK.get(), new Item.Properties()));
    public static final String STORAGE_IO_REG_NAME = "storage_io";
    public static final Supplier<StorageIOBlock> STORAGE_IO = BLOCKS.register("storage_io", StorageIOBlock::new);
    public static final String STORAGE_INPUT_REG_NAME = "storage_input";
    public static final Supplier<StorageIOBlock> STORAGE_INPUT = BLOCKS.register("storage_input", () -> new StorageIOBlock(){

        @Override
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new StorageInputBlockEntity(pos, state);
        }
    });
    public static final String STORAGE_OUTPUT_REG_NAME = "storage_output";
    public static final Supplier<StorageIOBlock> STORAGE_OUTPUT = BLOCKS.register("storage_output", () -> new StorageIOBlock(){

        @Override
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new StorageOutputBlockEntity(pos, state);
        }
    });
    public static final Supplier<BlockItem> STORAGE_IO_ITEM = ITEMS.register("storage_io", () -> new BlockItemBase((Block)STORAGE_IO.get(), new Item.Properties()));
    public static final Supplier<BlockItem> STORAGE_INPUT_ITEM = ITEMS.register("storage_input", () -> new BlockItemBase((Block)STORAGE_INPUT.get(), new Item.Properties()));
    public static final Supplier<BlockItem> STORAGE_OUTPUT_ITEM = ITEMS.register("storage_output", () -> new BlockItemBase((Block)STORAGE_OUTPUT.get(), new Item.Properties()));
    public static final Supplier<DecorationTableBlock> DECORATION_TABLE = BLOCKS.register("decoration_table", DecorationTableBlock::new);
    public static final Supplier<BlockItem> DECORATION_TABLE_ITEM = ITEMS.register("decoration_table", () -> new BlockItemBase((Block)DECORATION_TABLE.get(), new Item.Properties()));
    public static final Supplier<BlockEntityType<BarrelBlockEntity>> BARREL_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("barrel", () -> BlockEntityType.Builder.of(BarrelBlockEntity::new, (Block[])new Block[]{(Block)BARREL.get(), (Block)COPPER_BARREL.get(), (Block)IRON_BARREL.get(), (Block)GOLD_BARREL.get(), (Block)DIAMOND_BARREL.get(), (Block)NETHERITE_BARREL.get()}).build(null));
    public static final Supplier<BlockEntityType<LimitedBarrelBlockEntity>> LIMITED_BARREL_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("limited_barrel", () -> BlockEntityType.Builder.of(LimitedBarrelBlockEntity::new, (Block[])new Block[]{(Block)LIMITED_BARREL_1.get(), (Block)LIMITED_COPPER_BARREL_1.get(), (Block)LIMITED_IRON_BARREL_1.get(), (Block)LIMITED_GOLD_BARREL_1.get(), (Block)LIMITED_DIAMOND_BARREL_1.get(), (Block)LIMITED_NETHERITE_BARREL_1.get(), (Block)LIMITED_BARREL_2.get(), (Block)LIMITED_COPPER_BARREL_2.get(), (Block)LIMITED_IRON_BARREL_2.get(), (Block)LIMITED_GOLD_BARREL_2.get(), (Block)LIMITED_DIAMOND_BARREL_2.get(), (Block)LIMITED_NETHERITE_BARREL_2.get(), (Block)LIMITED_BARREL_3.get(), (Block)LIMITED_COPPER_BARREL_3.get(), (Block)LIMITED_IRON_BARREL_3.get(), (Block)LIMITED_GOLD_BARREL_3.get(), (Block)LIMITED_DIAMOND_BARREL_3.get(), (Block)LIMITED_NETHERITE_BARREL_3.get(), (Block)LIMITED_BARREL_4.get(), (Block)LIMITED_COPPER_BARREL_4.get(), (Block)LIMITED_IRON_BARREL_4.get(), (Block)LIMITED_GOLD_BARREL_4.get(), (Block)LIMITED_DIAMOND_BARREL_4.get(), (Block)LIMITED_NETHERITE_BARREL_4.get()}).build(null));
    public static final Supplier<BlockEntityType<ChestBlockEntity>> CHEST_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("chest", () -> BlockEntityType.Builder.of(ChestBlockEntity::new, (Block[])new Block[]{(Block)CHEST.get(), (Block)COPPER_CHEST.get(), (Block)IRON_CHEST.get(), (Block)GOLD_CHEST.get(), (Block)DIAMOND_CHEST.get(), (Block)NETHERITE_CHEST.get()}).build(null));
    public static final Supplier<BlockEntityType<ShulkerBoxBlockEntity>> SHULKER_BOX_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("shulker_box", () -> BlockEntityType.Builder.of(ShulkerBoxBlockEntity::new, (Block[])new Block[]{(Block)SHULKER_BOX.get(), (Block)COPPER_SHULKER_BOX.get(), (Block)IRON_SHULKER_BOX.get(), (Block)GOLD_SHULKER_BOX.get(), (Block)DIAMOND_SHULKER_BOX.get(), (Block)NETHERITE_SHULKER_BOX.get()}).build(null));
    public static final Supplier<BlockEntityType<ControllerBlockEntity>> CONTROLLER_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("controller", () -> BlockEntityType.Builder.of(ControllerBlockEntity::new, (Block[])new Block[]{(Block)CONTROLLER.get()}).build(null));
    public static final Supplier<BlockEntityType<StorageLinkBlockEntity>> STORAGE_LINK_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("storage_link", () -> BlockEntityType.Builder.of(StorageLinkBlockEntity::new, (Block[])new Block[]{(Block)STORAGE_LINK.get()}).build(null));
    public static final Supplier<BlockEntityType<StorageIOBlockEntity>> STORAGE_IO_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("storage_io", () -> BlockEntityType.Builder.of(StorageIOBlockEntity::new, (Block[])new Block[]{(Block)STORAGE_IO.get()}).build(null));
    public static final Supplier<BlockEntityType<StorageInputBlockEntity>> STORAGE_INPUT_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("storage_input", () -> BlockEntityType.Builder.of(StorageInputBlockEntity::new, (Block[])new Block[]{(Block)STORAGE_INPUT.get()}).build(null));
    public static final Supplier<BlockEntityType<StorageOutputBlockEntity>> STORAGE_OUTPUT_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("storage_output", () -> BlockEntityType.Builder.of(StorageOutputBlockEntity::new, (Block[])new Block[]{(Block)STORAGE_OUTPUT.get()}).build(null));
    public static final Supplier<BlockEntityType<DecorationTableBlockEntity>> DECORATION_TABLE_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("decoration_table", () -> BlockEntityType.Builder.of(DecorationTableBlockEntity::new, (Block[])new Block[]{(Block)DECORATION_TABLE.get()}).build(null));
    public static final Supplier<MenuType<StorageContainerMenu>> STORAGE_CONTAINER_TYPE = MENU_TYPES.register("storage", () -> IMenuTypeExtension.create(StorageContainerMenu::fromBuffer));
    public static final Supplier<MenuType<LimitedBarrelContainerMenu>> LIMITED_BARREL_CONTAINER_TYPE = MENU_TYPES.register("limited_barrel", () -> IMenuTypeExtension.create(LimitedBarrelContainerMenu::fromBuffer));
    public static final Supplier<MenuType<StorageSettingsContainerMenu>> SETTINGS_CONTAINER_TYPE = MENU_TYPES.register("settings", () -> IMenuTypeExtension.create(StorageSettingsContainerMenu::fromBuffer));
    public static final Supplier<MenuType<LimitedBarrelSettingsContainerMenu>> LIMITED_BARREL_SETTINGS_CONTAINER_TYPE = MENU_TYPES.register("limited_barrel_settings", () -> IMenuTypeExtension.create(LimitedBarrelSettingsContainerMenu::fromBuffer));
    public static final Supplier<MenuType<DecorationTableMenu>> DECORATION_TABLE_CONTAINER_TYPE = MENU_TYPES.register("decoration_table", () -> IMenuTypeExtension.create(DecorationTableMenu::fromBuffer));
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"sophisticatedstorage");
    public static final Supplier<SimpleCraftingRecipeSerializer<?>> STORAGE_DYE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("storage_dye", () -> new SimpleCraftingRecipeSerializer(StorageDyeRecipe::new));
    public static final Supplier<RecipeSerializer<?>> STORAGE_TIER_UPGRADE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("storage_tier_upgrade", StorageTierUpgradeRecipe.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> DOUBLE_CHEST_TIER_UPGRADE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("double_chest_tier_upgrade", DoubleChestTierUpgradeRecipe.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> SHULKER_BOX_FROM_VANILLA_SHAPELESS_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("shulker_box_from_vanilla_shapeless", ShulkerBoxFromVanillaShapelessRecipe.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> STORAGE_TIER_UPGRADE_SHAPELESS_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("storage_tier_upgrade_shapeless", StorageTierUpgradeShapelessRecipe.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> DOUBLE_CHEST_TIER_UPGRADE_SHAPELESS_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("double_chest_tier_upgrade_shapeless", DoubleChestTierUpgradeShapelessRecipe.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> SHULKER_BOX_FROM_CHEST_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("shulker_box_from_chest", ShulkerBoxFromChestRecipe.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> GENERIC_WOOD_STORAGE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("generic_wood_storage", GenericWoodStorageRecipe.Serializer::new);
    public static final Supplier<SimpleCraftingRecipeSerializer<?>> FLAT_TOP_BARREL_TOGGLE_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("flat_top_barrel_toggle", () -> new SimpleCraftingRecipeSerializer(FlatTopBarrelToggleRecipe::new));
    public static final Supplier<SimpleCraftingRecipeSerializer<?>> BARREL_MATERIAL_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("barrel_material", () -> new SimpleCraftingRecipeSerializer(BarrelMaterialRecipe::new));
    private static final DeferredRegister<IngredientType<?>> INGREDIENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.INGREDIENT_TYPES, (String)"sophisticatedstorage");
    public static final Supplier<IngredientType<BaseTierWoodenStorageIngredient>> BASE_TIER_WOODEN_STORAGE_INGREDIENT_TYPE = INGREDIENT_TYPES.register("base_tier_wooden_storage", () -> new IngredientType(BaseTierWoodenStorageIngredient.CODEC));

    private ModBlocks() {
    }

    public static void registerHandlers(IEventBus modBus) {
        BLOCKS.register(modBus);
        ITEMS.register(modBus);
        BLOCK_ENTITY_TYPES.register(modBus);
        MENU_TYPES.register(modBus);
        RECIPE_SERIALIZERS.register(modBus);
        INGREDIENT_TYPES.register(modBus);
        modBus.addListener(ModBlocks::registerCapabilities);
        if (FMLEnvironment.dist.isClient()) {
            ModBlocksClient.init(modBus);
        }
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, CONTROLLER_BLOCK_ENTITY_TYPE.get(), ControllerBlockEntity::getExternalItemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, CHEST_BLOCK_ENTITY_TYPE.get(), ChestBlockEntity::getExternalItemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, SHULKER_BOX_BLOCK_ENTITY_TYPE.get(), StorageBlockEntity::getExternalItemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, LIMITED_BARREL_BLOCK_ENTITY_TYPE.get(), WoodStorageBlockEntity::getExternalItemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BARREL_BLOCK_ENTITY_TYPE.get(), WoodStorageBlockEntity::getExternalItemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, STORAGE_IO_BLOCK_ENTITY_TYPE.get(), StorageIOBlockEntity::getExternalItemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, STORAGE_INPUT_BLOCK_ENTITY_TYPE.get(), StorageInputBlockEntity::getExternalItemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, STORAGE_OUTPUT_BLOCK_ENTITY_TYPE.get(), StorageOutputBlockEntity::getExternalItemHandler);
    }

    public static void registerDispenseBehavior() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)SHULKER_BOX_ITEM.get()), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
    }

    public static void registerCauldronInteractions() {
        CauldronInteraction.WATER.map().put((Item)BARREL_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)COPPER_BARREL_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)IRON_BARREL_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)GOLD_BARREL_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)DIAMOND_BARREL_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)NETHERITE_BARREL_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_BARREL_1_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_BARREL_2_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_BARREL_3_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_BARREL_4_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_COPPER_BARREL_1_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_COPPER_BARREL_2_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_COPPER_BARREL_3_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_COPPER_BARREL_4_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_IRON_BARREL_1_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_IRON_BARREL_2_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_IRON_BARREL_3_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_IRON_BARREL_4_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_GOLD_BARREL_1_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_GOLD_BARREL_2_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_GOLD_BARREL_3_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_GOLD_BARREL_4_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_DIAMOND_BARREL_1_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_DIAMOND_BARREL_2_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_DIAMOND_BARREL_3_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_DIAMOND_BARREL_4_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_NETHERITE_BARREL_1_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_NETHERITE_BARREL_2_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_NETHERITE_BARREL_3_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)LIMITED_NETHERITE_BARREL_4_ITEM.get(), BarrelCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)CHEST_ITEM.get(), WoodStorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)COPPER_CHEST_ITEM.get(), WoodStorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)IRON_CHEST_ITEM.get(), WoodStorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)GOLD_CHEST_ITEM.get(), WoodStorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)DIAMOND_CHEST_ITEM.get(), WoodStorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)NETHERITE_CHEST_ITEM.get(), WoodStorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)SHULKER_BOX_ITEM.get(), StorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)COPPER_SHULKER_BOX_ITEM.get(), StorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)IRON_SHULKER_BOX_ITEM.get(), StorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)GOLD_SHULKER_BOX_ITEM.get(), StorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)DIAMOND_SHULKER_BOX_ITEM.get(), StorageCauldronInteraction.INSTANCE);
        CauldronInteraction.WATER.map().put((Item)NETHERITE_SHULKER_BOX_ITEM.get(), StorageCauldronInteraction.INSTANCE);
    }

    public static class BarrelCauldronInteraction
    extends WoodStorageCauldronInteraction {
        private static final BarrelCauldronInteraction INSTANCE = new BarrelCauldronInteraction();

        @Override
        protected void removePaint(ItemStack stack) {
            super.removePaint(stack);
            BarrelBlockItem.removeMaterials(stack);
        }
    }

    public static class WoodStorageCauldronInteraction
    extends StorageCauldronInteraction {
        private static final WoodStorageCauldronInteraction INSTANCE = new WoodStorageCauldronInteraction();

        @Override
        protected void removePaint(ItemStack stack) {
            super.removePaint(stack);
            if (WoodStorageBlockItem.getWoodType((IDataComponentHolderExtension)stack).isEmpty()) {
                WoodStorageBlockItem.setWoodType(stack, WoodType.ACACIA);
            }
        }

        @Override
        protected boolean canRemovePaint(ItemStack stack) {
            return super.canRemovePaint(stack) && !WoodStorageBlockItem.isPacked(stack);
        }
    }

    public static class StorageCauldronInteraction
    implements CauldronInteraction {
        private static final StorageCauldronInteraction INSTANCE = new StorageCauldronInteraction();

        public ItemInteractionResult interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
            if (this.canRemovePaint(stack)) {
                if (!level.isClientSide()) {
                    this.removePaint(stack);
                    LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }

        protected boolean canRemovePaint(ItemStack stack) {
            return stack.getItem() instanceof ITintableBlockItem;
        }

        protected void removePaint(ItemStack stack) {
            Item item = stack.getItem();
            if (item instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                tintableBlockItem.removeMainColor(stack);
                tintableBlockItem.removeAccentColor(stack);
            }
        }
    }
}

