/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;

public class TierUpgradeRecipesMaker {
    private TierUpgradeRecipesMaker() {
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<RecipeHolder<CraftingRecipe>> getShapedCraftingRecipes(Function<ItemStack, Optional<T>> subtypeInterpreterGetter) {
        return TierUpgradeRecipesMaker.getShapedCraftingRecipes(subtypeInterpreterGetter, RecipeHolder::new);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapedCraftingRecipes(Function<ItemStack, Optional<T>> subtypeInterpreterGetter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        RecipeConstructor<StorageTierUpgradeRecipe> constructRecipe = (originalRecipe, ingredients, result) -> {
            ShapedRecipePattern pattern = new ShapedRecipePattern(originalRecipe.getWidth(), originalRecipe.getHeight(), ingredients, Optional.empty());
            return new ShapedRecipe("", CraftingBookCategory.MISC, pattern, result);
        };
        List<R> craftingRecipes = TierUpgradeRecipesMaker.getCraftingRecipes(constructRecipe, StorageTierUpgradeRecipe.class, TierUpgradeRecipesMaker::getStorageItems, subtypeInterpreterGetter, transformRecipe);
        RecipeConstructor<DoubleChestTierUpgradeRecipe> constructDoubleChestRecipe = (originalRecipe, ingredients, result) -> {
            ShapedRecipePattern pattern = new ShapedRecipePattern(originalRecipe.getWidth(), originalRecipe.getHeight(), ingredients, Optional.empty());
            return new ShapedRecipe("", CraftingBookCategory.MISC, pattern, result);
        };
        craftingRecipes.addAll(TierUpgradeRecipesMaker.getCraftingRecipes(constructDoubleChestRecipe, DoubleChestTierUpgradeRecipe.class, TierUpgradeRecipesMaker::getDoubleChestItems, subtypeInterpreterGetter, transformRecipe));
        return craftingRecipes;
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<RecipeHolder<CraftingRecipe>> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return TierUpgradeRecipesMaker.getShapelessCraftingRecipes(getSubtypeInterpreter, RecipeHolder::new);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        RecipeConstructor<StorageTierUpgradeShapelessRecipe> constructRecipe = (originalRecipe, ingredients, result) -> new ShapelessRecipe("", CraftingBookCategory.MISC, result, ingredients);
        List<R> craftingRecipes = TierUpgradeRecipesMaker.getCraftingRecipes(constructRecipe, StorageTierUpgradeShapelessRecipe.class, TierUpgradeRecipesMaker::getStorageItems, getSubtypeInterpreter, transformRecipe);
        RecipeConstructor<DoubleChestTierUpgradeShapelessRecipe> constructDoubleChestRecipe = (originalRecipe, ingredients, result) -> new ShapelessRecipe("", CraftingBookCategory.MISC, result, ingredients);
        craftingRecipes.addAll(TierUpgradeRecipesMaker.getCraftingRecipes(constructDoubleChestRecipe, DoubleChestTierUpgradeShapelessRecipe.class, TierUpgradeRecipesMaker::getDoubleChestItems, getSubtypeInterpreter, transformRecipe));
        return craftingRecipes;
    }

    private static <R, T extends CraftingRecipe, U extends PropertyBasedSubtypeInterpreter> List<R> getCraftingRecipes(RecipeConstructor<T> constructRecipe, Class<T> originalRecipeClass, Function<CraftingRecipe, List<ItemStack>> getStorageItems, Function<ItemStack, Optional<U>> getSubtypeInterpreter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        return ClientRecipeHelper.transformAllRecipesOfTypeIntoMultiple((RecipeType)RecipeType.CRAFTING, originalRecipeClass, recipe -> {
            ArrayList itemGroupRecipes = new ArrayList();
            ((List)getStorageItems.apply((CraftingRecipe)recipe)).forEach(storageItem -> {
                NonNullList ingredients = recipe.getIngredients();
                TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                    public ItemStack quickMoveStack(Player player, int index) {
                        return ItemStack.EMPTY;
                    }

                    public boolean stillValid(Player playerIn) {
                        return false;
                    }
                }, 3, 3);
                NonNullList ingredientsCopy = NonNullList.createWithCapacity((int)ingredients.size());
                int i = 0;
                for (Ingredient ingredient : ingredients) {
                    ItemStack[] ingredientItems = ingredient.getItems();
                    if (ingredientItems.length == 1 && storageItem.getItem() == ingredientItems[0].getItem()) {
                        ingredientsCopy.add(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{storageItem}));
                        craftinginventory.setItem(i, storageItem.copy());
                    } else {
                        ingredientsCopy.add(i, (Object)ingredient);
                        if (!ingredient.isEmpty()) {
                            craftinginventory.setItem(i, ingredientItems[0]);
                        }
                    }
                    ++i;
                }
                ItemStack result = ClientRecipeHelper.assemble((Recipe)recipe, (RecipeInput)craftinginventory.asCraftInput());
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorage", (String)("tier_upgrade_" + ((Optional)getSubtypeInterpreter.apply((ItemStack)storageItem)).map(interpreter -> interpreter.getRegistrySanitizedItemString(storageItem)).orElse("") + "_to_" + ((Optional)getSubtypeInterpreter.apply(result)).map(interpreter -> interpreter.getRegistrySanitizedItemString(result)).orElse("")));
                itemGroupRecipes.add(transformRecipe.apply(id, constructRecipe.construct(recipe, (NonNullList<Ingredient>)ingredientsCopy, result)));
            });
            return itemGroupRecipes;
        });
    }

    private static List<ItemStack> getDoubleChestItems(CraftingRecipe recipe) {
        NonNullList doubleChestItems = NonNullList.create();
        for (Ingredient ingredient : recipe.getIngredients()) {
            ItemStack[] ingredientItems;
            for (ItemStack ingredientItem : ingredientItems = ingredient.getItems()) {
                Item item = ingredientItem.getItem();
                if (!(item instanceof ChestBlockItem)) continue;
                ChestBlockItem chestBlockItem = (ChestBlockItem)item;
                chestBlockItem.addCreativeTabItems(stack -> {
                    ChestBlockItem.setDoubleChest(stack, true);
                    doubleChestItems.add(stack);
                });
            }
        }
        return doubleChestItems;
    }

    private static List<ItemStack> getStorageItems(CraftingRecipe recipe) {
        NonNullList storageItems = NonNullList.create();
        for (Ingredient ingredient : recipe.getIngredients()) {
            ItemStack[] ingredientItems;
            for (ItemStack ingredientItem : ingredientItems = ingredient.getItems()) {
                Item item = ingredientItem.getItem();
                if (!(item instanceof StorageBlockItem)) continue;
                StorageBlockItem storageBlockItem = (StorageBlockItem)item;
                storageBlockItem.addCreativeTabItems(arg_0 -> storageItems.add(arg_0));
            }
        }
        return storageItems;
    }

    private static interface RecipeConstructor<T extends Recipe<?>> {
        public CraftingRecipe construct(T var1, NonNullList<Ingredient> var2, ItemStack var3);
    }
}

