/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageContainerMenu
extends StorageContainerMenuBase<IStorageWrapper>
implements ISyncedContainer {
    private final StorageBlockEntity storageBlockEntity;

    public StorageContainerMenu(int containerId, Player player, BlockPos pos) {
        this(ModBlocks.STORAGE_CONTAINER_TYPE.get(), containerId, player, pos);
    }

    public StorageContainerMenu(MenuType<?> menuType, int containerId, Player player, BlockPos pos) {
        super(menuType, containerId, player, StorageContainerMenu.getWrapper(player.level(), pos), (IStorageWrapper)NoopStorageWrapper.INSTANCE, -1, false);
        this.storageBlockEntity = (StorageBlockEntity)WorldHelper.getBlockEntity((BlockGetter)player.level(), (BlockPos)pos, StorageBlockEntity.class).orElseThrow(() -> new IllegalArgumentException("Incorrect block entity at " + String.valueOf(pos) + " exptected to find StorageBlockEntity"));
        this.storageBlockEntity.startOpen(player);
    }

    public StorageBlockEntity getStorageBlockEntity() {
        return this.storageBlockEntity;
    }

    public void removed(Player player) {
        super.removed(player);
        this.storageBlockEntity.stopOpen(player);
    }

    private static IStorageWrapper getWrapper(Level level, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(be -> be.getStorageWrapper()).orElse((IStorageWrapper)NoopStorageWrapper.INSTANCE);
    }

    public static StorageContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new StorageContainerMenu(windowId, playerInventory.player, buffer.readBlockPos());
    }

    public Optional<BlockPos> getBlockPosition() {
        return Optional.of(this.storageBlockEntity.getBlockPos());
    }

    public Optional<Entity> getEntity() {
        return Optional.empty();
    }

    protected StorageContainerMenuBase.StorageUpgradeSlot instantiateUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
        return new StorageContainerMenuBase.StorageUpgradeSlot(upgradeHandler, slotIndex){

            protected void onUpgradeChanged() {
                if (StorageContainerMenu.this.player.level().isClientSide()) {
                    return;
                }
                ((ItemDisplaySettingsCategory)StorageContainerMenu.this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }
        };
    }

    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.putString("action", "openSettings"));
            return;
        }
        this.getBlockPosition().ifPresent(pos -> this.player.openMenu((MenuProvider)new SophisticatedMenuProvider((w, p, pl) -> this.instantiateSettingsContainerMenu(w, pl, (BlockPos)pos), (Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translGui("settings.title")), false), this.storageBlockEntity.getBlockPos()));
    }

    protected StorageSettingsContainerMenu instantiateSettingsContainerMenu(int windowId, Player player, BlockPos pos) {
        return new StorageSettingsContainerMenu(windowId, player, pos);
    }

    protected boolean storageItemHasChanged() {
        return false;
    }

    public boolean detectSettingsChangeAndReload() {
        return false;
    }

    public boolean stillValid(Player player) {
        WoodStorageBlockEntity woodStorageBlockEntity;
        BlockPos pos = this.storageBlockEntity.getBlockPos();
        BlockEntity be = player.level().getBlockEntity(pos);
        return be instanceof StorageBlockEntity && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0 && (!(be instanceof WoodStorageBlockEntity) || !(woodStorageBlockEntity = (WoodStorageBlockEntity)be).isPacked());
    }

    protected void onStorageInventorySlotSet(int slotIndex) {
        MemorySettingsCategory memorySettings;
        super.onStorageInventorySlotSet(slotIndex);
        if (this.getStorageBlockEntity().isLocked() && this.getStorageBlockEntity().memorizesItemsWhenLocked() && !this.getSlot(slotIndex).getItem().isEmpty() && !(memorySettings = (MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).isSlotSelected(slotIndex)) {
            memorySettings.selectSlot(slotIndex);
        }
    }

    public float getSlotFillPercentage(int slot) {
        return this.storageBlockEntity.getSlotFillPercentage(slot);
    }
}

