/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public abstract class SophisticatedOpenersCounter
extends ContainerOpenersCounter {
    private boolean isForPhysicalBlock = true;

    public void setForPhysicalBlock(boolean isForPhysicalBlock) {
        this.isForPhysicalBlock = isForPhysicalBlock;
    }

    public void incrementOpeners(Player player, Level level, BlockPos pos, BlockState state) {
        int i;
        if ((i = this.openCount++) == 0) {
            this.onOpen(level, pos, state);
            if (this.isForPhysicalBlock) {
                level.gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_OPEN, pos);
                SophisticatedOpenersCounter.scheduleRecheck((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
        this.openerCountChanged(level, pos, state, i, this.openCount);
        this.maxInteractionRange = Math.max(player.blockInteractionRange(), this.maxInteractionRange);
    }

    public void recheckOpeners(Level level, BlockPos pos, BlockState state) {
        List list = this.getPlayersWithContainerOpen(level, pos);
        this.maxInteractionRange = 0.0;
        for (Player player : list) {
            this.maxInteractionRange = Math.max(player.blockInteractionRange(), this.maxInteractionRange);
        }
        int j = this.openCount;
        int i = list.size();
        if (j != i) {
            boolean flag1;
            boolean flag = i != 0;
            boolean bl = flag1 = j != 0;
            if (flag && !flag1) {
                this.onOpen(level, pos, state);
                if (this.isForPhysicalBlock) {
                    level.gameEvent(null, (Holder)GameEvent.CONTAINER_OPEN, pos);
                }
            } else if (!flag) {
                this.onClose(level, pos, state);
                if (this.isForPhysicalBlock) {
                    level.gameEvent(null, (Holder)GameEvent.CONTAINER_CLOSE, pos);
                }
            }
            this.openCount = i;
        }
        this.openerCountChanged(level, pos, state, j, i);
        if (this.isForPhysicalBlock && i > 0) {
            SophisticatedOpenersCounter.scheduleRecheck((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }
}

