/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.CachedFailedInsertInventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ControllerBlockEntity
extends ControllerBlockEntityBase
implements ILockable,
ICountDisplay,
ITierDisplay,
IUpgradeDisplay,
IFillLevelDisplay {
    private long lastDepositTime = -100L;
    @Nullable
    private IItemHandler cachedFailedInsertItemHandler;

    public ControllerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.CONTROLLER_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public void depositPlayerItems(Player player, InteractionHand hand) {
        if (this.getLevel() == null) {
            return;
        }
        long gameTime = this.getLevel().getGameTime();
        boolean doubleClick = gameTime - this.lastDepositTime < 10L;
        this.lastDepositTime = gameTime;
        if (doubleClick) {
            CapabilityHelper.runOnCapability((Entity)player, (EntityCapability)Capabilities.ItemHandler.ENTITY, null, playerInventory -> InventoryHelper.iterate((IItemHandler)playerInventory, (slot, stack) -> {
                if (this.canDepositStack((ItemStack)stack)) {
                    ItemStack resultStack = this.insertItem((ItemStack)stack, true, false);
                    int countToExtract = stack.getCount() - resultStack.getCount();
                    if (countToExtract > 0 && playerInventory.extractItem(slot.intValue(), countToExtract, true).getCount() == countToExtract) {
                        this.insertItem(playerInventory.extractItem(slot.intValue(), countToExtract, false), false, false);
                    }
                }
            }));
            return;
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        if (!itemInHand.isEmpty() && this.canDepositStack(itemInHand)) {
            player.setItemInHand(hand, this.insertItem(itemInHand, false, false));
        }
    }

    private boolean canDepositStack(ItemStack stack) {
        return this.hasItem(stack.getItem()) || this.isMemorizedItem(stack) || this.isFilterItem(stack.getItem());
    }

    @Override
    public void toggleLock() {
        HashSet unlockedStorages = new HashSet();
        HashSet lockedStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.level, (BlockPos)storagePosition, ILockable.class).ifPresent(lockable -> {
            if (lockable.isLocked()) {
                lockedStorages.add(lockable);
            } else {
                unlockedStorages.add(lockable);
            }
        }));
        if (unlockedStorages.isEmpty()) {
            lockedStorages.forEach(ILockable::toggleLock);
        } else {
            unlockedStorages.forEach(ILockable::toggleLock);
        }
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean shouldShowLock() {
        return false;
    }

    @Override
    public void toggleLockVisibility() {
        HashSet invisibleLockStorages = new HashSet();
        HashSet visibleLockStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.level, (BlockPos)storagePosition, ILockable.class).ifPresent(lockable -> {
            if (lockable.isLocked()) {
                if (lockable.shouldShowLock()) {
                    visibleLockStorages.add(lockable);
                } else {
                    invisibleLockStorages.add(lockable);
                }
            }
        }));
        if (invisibleLockStorages.isEmpty()) {
            visibleLockStorages.forEach(ILockable::toggleLockVisibility);
        } else {
            invisibleLockStorages.forEach(ILockable::toggleLockVisibility);
        }
    }

    @Override
    public boolean shouldShowCounts() {
        return false;
    }

    @Override
    public void toggleCountVisibility() {
        HashSet invisibleCountStorages = new HashSet();
        HashSet visibleCountStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.level, (BlockPos)storagePosition, ICountDisplay.class).ifPresent(countDisplay -> {
            if (countDisplay.shouldShowCounts()) {
                visibleCountStorages.add(countDisplay);
            } else {
                invisibleCountStorages.add(countDisplay);
            }
        }));
        if (invisibleCountStorages.isEmpty()) {
            visibleCountStorages.forEach(ICountDisplay::toggleCountVisibility);
        } else {
            invisibleCountStorages.forEach(ICountDisplay::toggleCountVisibility);
        }
    }

    @Override
    public List<Integer> getSlotCounts() {
        return List.of();
    }

    @Override
    public boolean shouldShowTier() {
        return false;
    }

    @Override
    public void toggleTierVisiblity() {
        HashSet invisibleTierStorages = new HashSet();
        HashSet visibleTierStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.level, (BlockPos)storagePosition, ITierDisplay.class).ifPresent(tierDisplay -> {
            if (tierDisplay.shouldShowTier()) {
                visibleTierStorages.add(tierDisplay);
            } else {
                invisibleTierStorages.add(tierDisplay);
            }
        }));
        if (invisibleTierStorages.isEmpty()) {
            visibleTierStorages.forEach(ITierDisplay::toggleTierVisiblity);
        } else {
            invisibleTierStorages.forEach(ITierDisplay::toggleTierVisiblity);
        }
    }

    @Override
    public boolean shouldShowUpgrades() {
        return false;
    }

    @Override
    public void toggleUpgradesVisiblity() {
        HashSet invisibleUpgradeStorages = new HashSet();
        HashSet visibleUpgradeStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.level, (BlockPos)storagePosition, IUpgradeDisplay.class).ifPresent(upgradeDisplay -> {
            if (upgradeDisplay.shouldShowUpgrades()) {
                visibleUpgradeStorages.add(upgradeDisplay);
            } else {
                invisibleUpgradeStorages.add(upgradeDisplay);
            }
        }));
        if (invisibleUpgradeStorages.isEmpty()) {
            visibleUpgradeStorages.forEach(IUpgradeDisplay::toggleUpgradesVisiblity);
        } else {
            invisibleUpgradeStorages.forEach(IUpgradeDisplay::toggleUpgradesVisiblity);
        }
    }

    @Override
    public boolean shouldShowFillLevels() {
        return false;
    }

    @Override
    public void toggleFillLevelVisibility() {
        HashSet invisibleFillLevelStorages = new HashSet();
        HashSet visibleFillLevelStorages = new HashSet();
        this.getStoragePositions().forEach(storagePosition -> WorldHelper.getLoadedBlockEntity((Level)this.level, (BlockPos)storagePosition, IFillLevelDisplay.class).ifPresent(fillLevelDisplay -> {
            if (fillLevelDisplay.shouldShowFillLevels()) {
                visibleFillLevelStorages.add(fillLevelDisplay);
            } else {
                invisibleFillLevelStorages.add(fillLevelDisplay);
            }
        }));
        if (invisibleFillLevelStorages.isEmpty()) {
            visibleFillLevelStorages.forEach(IFillLevelDisplay::toggleFillLevelVisibility);
        } else {
            invisibleFillLevelStorages.forEach(IFillLevelDisplay::toggleFillLevelVisibility);
        }
    }

    @Override
    public List<Float> getSlotFillLevels() {
        return List.of();
    }

    public IItemHandler getExternalItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this;
        }
        if (this.cachedFailedInsertItemHandler == null) {
            this.cachedFailedInsertItemHandler = new CachedFailedInsertInventoryHandler(() -> this, () -> this.level != null ? this.level.getGameTime() : 0L);
        }
        return this.cachedFailedInsertItemHandler;
    }

    protected int getSearchRange() {
        return Config.SERVER.controllerRange.getAsInt();
    }
}

