/*
 * Decompiled with CFR 0.152.
 */
package fuzs.metalbundles.world.item.container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.iteminteractions.api.v1.DyeBackedColor;
import fuzs.iteminteractions.api.v1.provider.ItemContentsProvider;
import fuzs.iteminteractions.api.v1.provider.impl.BundleProvider;
import fuzs.metalbundles.MetalBundles;
import fuzs.metalbundles.config.ServerConfig;
import fuzs.metalbundles.init.ModRegistry;
import fuzs.metalbundles.world.item.BundleType;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public class MetalBundleProvider
extends BundleProvider {
    public static final MapCodec<MetalBundleProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BundleType.CODEC.fieldOf("bundle_type").forGetter(provider -> provider.bundleType), (App)MetalBundleProvider.backgroundColorCodec(), (App)MetalBundleProvider.disallowedItemsCodec()).apply((Applicative)instance, (bundleType, dyeColor, disallowedItems) -> new MetalBundleProvider((BundleType)((Object)((Object)bundleType)), dyeColor.orElse(null)).disallowedItems((HolderSet)disallowedItems)));
    private final BundleType bundleType;

    public MetalBundleProvider(BundleType bundleType, @Nullable DyeBackedColor dyeColor) {
        super(dyeColor);
        this.bundleType = bundleType;
    }

    public MetalBundleProvider disallowedItems(HolderSet<Item> disallowedItems) {
        return (MetalBundleProvider)super.disallowedItems(disallowedItems);
    }

    public Fraction getCapacityMultiplier() {
        int capacityMultiplier = switch (this.bundleType) {
            default -> throw new MatchException(null, null);
            case BundleType.LEATHER -> ((ServerConfig)MetalBundles.CONFIG.get(ServerConfig.class)).leatherCapacityMultiplier;
            case BundleType.COPPER -> ((ServerConfig)MetalBundles.CONFIG.get(ServerConfig.class)).copperCapacityMultiplier;
            case BundleType.IRON -> ((ServerConfig)MetalBundles.CONFIG.get(ServerConfig.class)).ironCapacityMultiplier;
            case BundleType.GOLDEN -> ((ServerConfig)MetalBundles.CONFIG.get(ServerConfig.class)).goldenCapacityMultiplier;
            case BundleType.DIAMOND -> ((ServerConfig)MetalBundles.CONFIG.get(ServerConfig.class)).diamondCapacityMultiplier;
            case BundleType.NETHERITE -> ((ServerConfig)MetalBundles.CONFIG.get(ServerConfig.class)).netheriteCapacityMultiplier;
        };
        return Fraction.getFraction((int)capacityMultiplier, (int)1);
    }

    public ItemContentsProvider.Type getType() {
        return (ItemContentsProvider.Type)ModRegistry.METAL_BUNDLE_ITEM_CONTENTS_PROVIDER_TYPE.value();
    }
}

