/*
 * Decompiled with CFR 0.152.
 */
package fuzs.metalbundles.world.item;

import com.mojang.serialization.Codec;
import fuzs.iteminteractions.api.v1.DyeBackedColor;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.MapColor;

public enum BundleType implements StringRepresentable
{
    LEATHER(MapColor.COLOR_BROWN),
    COPPER(MapColor.COLOR_ORANGE),
    IRON(MapColor.METAL),
    GOLDEN(DyeColor.YELLOW),
    DIAMOND(MapColor.DIAMOND),
    NETHERITE(MapColor.COLOR_GRAY);

    public static final Codec<BundleType> CODEC;
    public final DyeBackedColor fallbackColor;

    private BundleType(DyeColor dyeColor) {
        this.fallbackColor = DyeBackedColor.fromDyeColor((DyeColor)dyeColor);
    }

    private BundleType(MapColor mapColor) {
        this.fallbackColor = DyeBackedColor.fromMapColor((MapColor)mapColor);
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.fromValues(BundleType::values);
    }
}

